/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.configurator;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogService;

public class Configurator
implements Runnable {
    private static final String DELIM_START = "${";
    private static final String DELIM_STOP = "}";
    private static final FileFilter FILENAME_FILTER = new FileFilter(){

        public boolean accept(File file) {
            return !file.isHidden() && (file.getName().endsWith(".cfg") || file.isDirectory());
        }
    };
    private static final String FACTORY_INSTANCE_KEY = "factory.instance.pid";
    private volatile LogService m_log;
    private volatile ConfigurationAdmin m_configAdmin;
    private volatile BundleContext m_context;
    private final File m_configDir;
    private final long m_pollInterval;
    private final Map m_checksums = new HashMap();
    private final Map m_foundFactories = new HashMap();
    private Thread m_configThread;
    private final boolean m_reconfig;

    public Configurator(File dir, long pollInterval, boolean reconfig) {
        if (dir == null || !dir.isDirectory() || pollInterval < 0L) {
            throw new IllegalArgumentException("Bad arguments; either not an existing directory or an invalid interval.");
        }
        this.m_configDir = dir;
        this.m_pollInterval = pollInterval;
        this.m_reconfig = reconfig;
    }

    synchronized void start() {
        if (this.m_configThread == null) {
            this.m_configThread = new Thread((Runnable)this, "Apache ACE Configurator");
        }
        this.m_configThread.setDaemon(true);
        this.m_configThread.start();
    }

    synchronized void stop() throws InterruptedException {
        this.m_configThread.interrupt();
        this.m_configThread.join();
        this.m_configThread = null;
        this.m_checksums.clear();
    }

    public void run() {
        try {
            while (!Thread.interrupted()) {
                this.doConfigs();
                Thread.sleep(this.m_pollInterval);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doConfigs() {
        HashSet pids = new HashSet(this.m_checksums.keySet());
        File[] files = this.m_configDir.listFiles(FILENAME_FILTER);
        for (int i = 0; files != null && i < files.length; ++i) {
            Long oldChecksum;
            File file = files[i];
            String pid = this.parsePid(file);
            if (file.isDirectory()) {
                this.doFactoryConfigs(pid, file.listFiles(FILENAME_FILTER));
                continue;
            }
            Long newChecksum = new Long(file.lastModified() ^ file.length());
            if (!newChecksum.equals(oldChecksum = (Long)this.m_checksums.get(pid))) {
                this.m_checksums.put(pid, newChecksum);
                this.processConfigFile(file, null);
            }
            pids.remove(pid);
        }
        for (String pid : pids) {
            this.deleteConfig(pid, null);
            this.m_checksums.remove(pid);
        }
    }

    private void doFactoryConfigs(String factoryPid, File[] newInstances) {
        if (!this.m_foundFactories.containsKey(factoryPid)) {
            this.m_foundFactories.put(factoryPid, new HashMap());
        }
        Map instances = (Map)this.m_foundFactories.get(factoryPid);
        HashSet instancesPids = new HashSet(instances.keySet());
        for (int j = 0; j < newInstances.length; ++j) {
            Long oldChecksum;
            File instanceConfigFile = newInstances[j];
            String instancePid = this.parsePid(instanceConfigFile);
            Long newChecksum = new Long(instanceConfigFile.lastModified() ^ instanceConfigFile.length());
            if (!newChecksum.equals(oldChecksum = (Long)instances.get(instancePid))) {
                instances.put(instancePid, newChecksum);
                this.processConfigFile(instanceConfigFile, factoryPid);
            }
            instancesPids.remove(instancePid);
        }
        for (String instancePid : instancesPids) {
            this.deleteConfig(instancePid, factoryPid);
            instances.remove(instancePid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConfigFile(File configFile, String factoryPid) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(configFile);
            Properties properties = new Properties();
            properties.load(in);
            String pid = this.parsePid(configFile);
            properties = this.substVars(properties);
            this.configure(pid, factoryPid, properties);
        }
        catch (IOException ex) {
            this.m_log.log(1, "Unable to read configuration from file: " + configFile.getAbsolutePath(), (Throwable)ex);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (Exception ex) {}
            }
        }
    }

    private void configure(String pid, String factoryPid, Properties properties) {
        try {
            Configuration config = this.getConfiguration(pid, factoryPid);
            Dictionary oldProps = config.getProperties();
            if (!this.m_reconfig && oldProps != null) {
                Enumeration keys = oldProps.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    if (!properties.containsKey(key)) continue;
                    properties.put(key, oldProps.get(key));
                    this.m_log.log(4, "Using previously configured value for bundle=" + pid + " key=" + key);
                }
            }
            if (factoryPid != null) {
                properties.put(FACTORY_INSTANCE_KEY, factoryPid + "_" + pid);
            }
            config.update((Dictionary)properties);
            this.m_log.log(4, "Updated configuration for pid '" + pid + "' (" + properties + ")");
        }
        catch (IOException ex) {
            this.m_log.log(1, "Unable to update configuration for pid '" + pid + "'", (Throwable)ex);
        }
    }

    private Configuration getConfiguration(String pid, String factoryPid) throws IOException {
        if (factoryPid != null) {
            Configuration[] configs = null;
            try {
                configs = this.m_configAdmin.listConfigurations("(factory.instance.pid=" + factoryPid + "_" + pid + ")");
            }
            catch (InvalidSyntaxException e) {
                this.m_log.log(1, "Exception during lookup of configuration of managed service factory instance '" + pid + "'", (Throwable)e);
            }
            if (configs == null || configs.length == 0) {
                return this.m_configAdmin.createFactoryConfiguration(factoryPid, null);
            }
            return configs[0];
        }
        return this.m_configAdmin.getConfiguration(pid, null);
    }

    protected void deleteConfig(String pid, String factoryPid) {
        try {
            Configuration config = this.getConfiguration(pid, factoryPid);
            config.delete();
            this.m_log.log(4, "Removed configuration for pid '" + pid + "'");
        }
        catch (Exception e) {
            this.m_log.log(1, "Unable to remove configuration for pid '" + pid + "'", (Throwable)e);
        }
    }

    protected String parsePid(File file) {
        String name = file.getName();
        if (file.isDirectory()) {
            return name;
        }
        return name.substring(0, name.length() - 4);
    }

    private Properties substVars(Properties properties) {
        Enumeration<?> propertyKeys = properties.propertyNames();
        while (propertyKeys.hasMoreElements()) {
            String name = (String)propertyKeys.nextElement();
            String value = properties.getProperty(name);
            properties.setProperty(name, this.substVars(value, name, null, properties));
        }
        return properties;
    }

    private String substVars(String val, String currentKey, Map cycleMap, Properties configProps) throws IllegalArgumentException {
        String substValue;
        int idx;
        if (cycleMap == null) {
            cycleMap = new HashMap<String, String>();
        }
        cycleMap.put(currentKey, currentKey);
        int stopDelim = val.indexOf(DELIM_STOP);
        int startDelim = val.indexOf(DELIM_START);
        while (stopDelim >= 0 && (idx = val.indexOf(DELIM_START, startDelim + DELIM_START.length())) >= 0 && idx <= stopDelim) {
            if (idx >= stopDelim) continue;
            startDelim = idx;
        }
        if (startDelim < 0 && stopDelim < 0) {
            return val;
        }
        if ((startDelim < 0 || startDelim > stopDelim) && stopDelim >= 0) {
            throw new IllegalArgumentException("stop delimiter with no start delimiter: " + val);
        }
        String variable = val.substring(startDelim + DELIM_START.length(), stopDelim);
        if (cycleMap.get(variable) != null) {
            throw new IllegalArgumentException("recursive variable reference: " + variable);
        }
        String string = substValue = configProps != null ? configProps.getProperty(variable, null) : null;
        if (substValue == null && (substValue = this.m_context.getProperty(variable)) == null) {
            substValue = "";
        }
        cycleMap.remove(variable);
        val = val.substring(0, startDelim) + substValue + val.substring(stopDelim + DELIM_STOP.length(), val.length());
        val = this.substVars(val, currentKey, cycleMap, configProps);
        return val;
    }
}

