/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.configurator.serveruseradmin;

import java.util.Dictionary;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyActivatorBase;
import org.apache.felix.dm.DependencyManager;
import org.osgi.framework.BundleContext;
import org.osgi.service.log.LogService;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class Activator
extends DependencyActivatorBase {
    private static final String TEST_USER = "serverUser";
    private static final String TEST_PASSWORD = "serverPassword";
    private volatile UserAdmin m_userAdmin;
    private volatile LogService m_log;

    public void init(BundleContext context, DependencyManager manager) throws Exception {
        manager.add(this.createComponent().setImplementation((Object)this).add((Dependency)this.createServiceDependency().setService(UserAdmin.class).setRequired(true)).add((Dependency)this.createServiceDependency().setService(LogService.class).setRequired(false)));
    }

    public void destroy(BundleContext context, DependencyManager manager) throws Exception {
    }

    public synchronized void start() {
        this.createUser(TEST_USER, TEST_PASSWORD);
    }

    private User createUser(String username, String password) {
        User user = (User)this.m_userAdmin.createRole(username, 1);
        if (user != null) {
            Dictionary properties = user.getProperties();
            if (properties != null) {
                properties.put("username", username);
            } else {
                this.m_log.log(1, "Could not get properties for " + username);
            }
            Dictionary credentials = user.getCredentials();
            if (credentials != null) {
                credentials.put("password", password);
            } else {
                this.m_log.log(1, "Could not get credentials for " + username);
            }
        } else {
            try {
                user = (User)this.m_userAdmin.getRole(username);
                this.m_log.log(2, "User " + username + " already existed.");
            }
            catch (ClassCastException e) {
                this.m_log.log(2, "Role " + username + " already existed (it's no user).");
            }
        }
        return user;
    }
}

