/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.client.repository.helper.configuration.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ace.client.repository.helper.ArtifactPreprocessor;
import org.apache.ace.client.repository.helper.ArtifactRecognizer;
import org.apache.ace.client.repository.helper.ArtifactResource;
import org.apache.ace.client.repository.helper.base.VelocityArtifactPreprocessor;
import org.apache.ace.client.repository.helper.configuration.ConfigurationHelper;
import org.apache.ace.client.repository.object.ArtifactObject;
import org.apache.ace.connectionfactory.ConnectionFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationHelperImpl
implements ArtifactRecognizer,
ConfigurationHelper {
    private static final String NAMESPACE_1_0 = "http://www.osgi.org/xmlns/metatype/v1.0.0";
    private static final String NAMESPACE_1_1 = "http://www.osgi.org/xmlns/metatype/v1.1.0";
    private static final String NAMESPACE_1_2 = "http://www.osgi.org/xmlns/metatype/v1.2.0";
    private final SAXParserFactory m_saxParserFactory = SAXParserFactory.newInstance();
    private volatile ConnectionFactory m_connectionFactory;
    private volatile VelocityArtifactPreprocessor m_artifactPreprocessor;

    public ConfigurationHelperImpl() {
        this.m_saxParserFactory.setNamespaceAware(false);
        this.m_saxParserFactory.setValidating(false);
    }

    public boolean canHandle(String mimetype) {
        return "application/xml:osgi-autoconf".equals(mimetype);
    }

    public Map<String, String> extractMetaData(ArtifactResource artifact) throws IllegalArgumentException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("processorPid", "org.osgi.deployment.rp.autoconf");
        result.put("mimetype", "application/xml:osgi-autoconf");
        String name = new File(artifact.getURL().getFile()).getName();
        String key = "filename-";
        int idx = name.indexOf(key);
        if (idx > -1) {
            int endIdx = name.indexOf("-", idx + key.length());
            name = name.substring(idx + key.length(), endIdx > -1 ? endIdx : name.length() - this.getExtension(artifact).length());
        }
        result.put("artifactName", name);
        result.put("filename", name);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String recognize(ArtifactResource artifact) {
        MetaDataNamespaceCollector handler = new MetaDataNamespaceCollector();
        InputStream input = null;
        try {
            input = artifact.openStream();
            SAXParser parser = this.m_saxParserFactory.newSAXParser();
            parser.parse(input, (DefaultHandler)handler);
        }
        catch (Exception e) {
            String namespace = handler.getMetaDataNamespace();
            if (namespace != null && (namespace.equals(NAMESPACE_1_0) || namespace.equals(NAMESPACE_1_1) || namespace.equals(NAMESPACE_1_2))) {
                String string = "application/xml:osgi-autoconf";
                return string;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public boolean canUse(ArtifactObject object) {
        return "application/xml:osgi-autoconf".equals(object.getMimetype());
    }

    public Map<String, String> checkAttributes(Map<String, String> attributes) {
        return attributes;
    }

    public <TYPE extends ArtifactObject> String getAssociationFilter(TYPE obj, Map<String, String> properties) {
        return "(filename=" + obj.getAttribute("filename") + ")";
    }

    public <TYPE extends ArtifactObject> int getCardinality(TYPE obj, Map<String, String> properties) {
        return Integer.MAX_VALUE;
    }

    public Comparator<ArtifactObject> getComparator() {
        return null;
    }

    public String[] getDefiningKeys() {
        return new String[]{"filename"};
    }

    public String[] getMandatoryAttributes() {
        return new String[]{"filename"};
    }

    public ArtifactPreprocessor getPreprocessor() {
        return this.m_artifactPreprocessor;
    }

    public String getExtension(ArtifactResource artifact) {
        return ".xml";
    }

    protected void start() {
        this.m_artifactPreprocessor = new VelocityArtifactPreprocessor(this.m_connectionFactory);
    }

    protected void stop() {
        this.m_artifactPreprocessor = null;
    }

    static class MetaDataNamespaceCollector
    extends DefaultHandler {
        private String m_metaDataNameSpace = "";

        MetaDataNamespaceCollector() {
        }

        public String getMetaDataNamespace() {
            return this.m_metaDataNameSpace;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("MetaData") || qName.endsWith(":MetaData")) {
                String nsAttributeQName = "xmlns";
                if (qName.endsWith(":MetaData")) {
                    nsAttributeQName = "xmlns:" + qName.split(":")[0];
                }
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (!attributes.getQName(i).equals(nsAttributeQName)) continue;
                    this.m_metaDataNameSpace = attributes.getValue(i);
                }
            }
            throw new SAXException("Done");
        }
    }
}

