/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.client.automation;

import java.io.IOException;
import java.net.URL;
import java.util.Dictionary;
import java.util.List;
import java.util.Properties;
import org.apache.ace.client.repository.RepositoryAdmin;
import org.apache.ace.client.repository.RepositoryAdminLoginContext;
import org.apache.ace.client.repository.stateful.StatefulTargetObject;
import org.apache.ace.client.repository.stateful.StatefulTargetRepository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.log.LogService;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

public class AutoTargetOperator
implements ManagedService {
    public static final String PID = "org.apache.ace.client.automation";
    public static final String SCHEDULER_NAME = "org.apache.ace.client.processauditlog";
    private volatile StatefulTargetRepository m_statefulTargetRepos;
    private volatile RepositoryAdmin m_reposAdmin;
    private volatile UserAdmin m_userAdmin;
    private volatile BundleContext m_bundleContext;
    private volatile LogService m_log;
    private volatile Dictionary m_settings;
    private static String username = "serverUser";
    private final AuditLogProcessTask m_task = new AuditLogProcessTask();
    private Object m_serviceReg = null;

    public void start() {
        User user = this.m_userAdmin.getUser("username", username);
        try {
            URL url = new URL(this.getConfigValue(ConfigItem.HOSTNAME) + this.getConfigValue(ConfigItem.ENDPOINT));
            String customerName = this.getConfigValue(ConfigItem.CUSTOMER_NAME);
            RepositoryAdminLoginContext loginContext = this.m_reposAdmin.createLoginContext(user);
            loginContext.addShopRepository(url, customerName, this.getConfigValue(ConfigItem.STORE_REPOSITORY), false).addTargetRepository(url, customerName, this.getConfigValue(ConfigItem.TARGET_REPOSITORY), true).addDeploymentRepository(url, customerName, this.getConfigValue(ConfigItem.DEPLOYMENT_REPOSITORY), true);
            this.m_reposAdmin.login(loginContext);
            Properties props = new Properties();
            props.put("taskName", SCHEDULER_NAME);
            this.m_serviceReg = this.m_bundleContext.registerService(Runnable.class.getName(), (Object)this.m_task, (Dictionary)props);
        }
        catch (IOException ioe) {
            this.m_log.log(1, "Unable to login at repository admin.", (Throwable)ioe);
        }
    }

    public void stop() {
        if (this.m_serviceReg != null) {
            ((ServiceRegistration)this.m_serviceReg).unregister();
        }
        this.m_serviceReg = null;
        try {
            this.m_reposAdmin.logout(true);
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
    }

    private void checkoutModel() throws IOException {
        if (!this.m_reposAdmin.isCurrent()) {
            this.m_reposAdmin.checkout();
        }
    }

    private boolean registerTargets() throws InvalidSyntaxException {
        boolean changed = false;
        String filter = "(&" + this.getConfigValue(ConfigItem.REGISTER_TARGET_FILTER) + "(" + "KEY_REGISTRATION_STATE" + "=" + StatefulTargetObject.RegistrationState.Unregistered + "))";
        List stos = this.m_statefulTargetRepos.get(this.m_bundleContext.createFilter(filter));
        for (StatefulTargetObject sto : stos) {
            sto.register();
            changed = true;
        }
        return changed;
    }

    private boolean setAutoApprove() throws InvalidSyntaxException {
        boolean changed = false;
        String filter = "(&" + this.getConfigValue(ConfigItem.AUTO_APPROVE_TARGET_FILTER) + "(" + "KEY_REGISTRATION_STATE" + "=" + StatefulTargetObject.RegistrationState.Registered + ")" + "(!(" + "autoapprove" + "=true)))";
        List stos = this.m_statefulTargetRepos.get(this.m_bundleContext.createFilter(filter));
        for (StatefulTargetObject sto : stos) {
            sto.setAutoApprove(true);
            changed = true;
        }
        return changed;
    }

    private boolean approveTargets() throws InvalidSyntaxException {
        boolean changed = false;
        String filter = "(&" + this.getConfigValue(ConfigItem.APPROVE_TARGET_FILTER) + "(" + "KEY_STORE_STATE" + "=" + StatefulTargetObject.StoreState.Unapproved + "))";
        List stos = this.m_statefulTargetRepos.get(this.m_bundleContext.createFilter(filter));
        for (StatefulTargetObject sto : stos) {
            sto.approve();
            changed = true;
        }
        return changed;
    }

    public void updated(Dictionary settings) throws ConfigurationException {
        if (settings != null) {
            for (ConfigItem item : ConfigItem.values()) {
                String value = (String)settings.get(item.toString());
                if (value != null && !value.equals("")) continue;
                throw new ConfigurationException(item.toString(), item.getErrorText());
            }
            this.m_settings = settings;
        }
    }

    private String getConfigValue(ConfigItem item) {
        return (String)this.m_settings.get(item.toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ConfigItem {
        REGISTER_TARGET_FILTER("registerTargetFilter", "Register target filter missing", true),
        APPROVE_TARGET_FILTER("approveTargetFilter", "Approve target filter missing", true),
        AUTO_APPROVE_TARGET_FILTER("autoApproveTargetFilter", "Auto approve config value missing", true),
        COMMIT_REPO("commitRepositories", "Commit value missing.", false),
        TARGET_REPOSITORY("targetRepository", "TargetRepository id missing.", false),
        DEPLOYMENT_REPOSITORY("deploymentRepository", "DeploymentRepository id missing.", false),
        STORE_REPOSITORY("storeRepository", "Store Repository id missing.", false),
        CUSTOMER_NAME("customerName", "Customer name missing", false),
        HOSTNAME("hostName", "Hostname missing.", false),
        ENDPOINT("endpoint", "Endpoint missing in config.", false);

        private final String m_name;
        private final String m_errorText;
        private final boolean m_isFilter;

        private ConfigItem(String name, String errorText, boolean isFilter) {
            this.m_name = name;
            this.m_errorText = errorText;
            this.m_isFilter = isFilter;
        }

        public String toString() {
            return this.m_name;
        }

        public String getErrorText() {
            return this.m_errorText;
        }

        public boolean isFilter() {
            return this.m_isFilter;
        }
    }

    private final class AuditLogProcessTask
    implements Runnable {
        private final Object m_lock = new Object();

        private AuditLogProcessTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object = this.m_lock;
            synchronized (object) {
                AutoTargetOperator.this.m_statefulTargetRepos.refresh();
                boolean changed = false;
                try {
                    AutoTargetOperator.this.checkoutModel();
                    changed |= AutoTargetOperator.this.registerTargets();
                    changed |= AutoTargetOperator.this.approveTargets();
                    changed |= AutoTargetOperator.this.setAutoApprove();
                }
                catch (IOException ioe) {
                    AutoTargetOperator.this.m_log.log(2, "Checkout of model failed.", (Throwable)ioe);
                }
                catch (InvalidSyntaxException ise) {
                    AutoTargetOperator.this.m_log.log(2, "Illegal register target filter.", (Throwable)ise);
                }
                try {
                    if (changed) {
                        AutoTargetOperator.this.m_reposAdmin.commit();
                    }
                }
                catch (IOException ioe) {
                    AutoTargetOperator.this.m_log.log(2, "Commit of model failed", (Throwable)ioe);
                }
            }
        }

        public void run() {
            this.process();
        }
    }
}

