/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.ace.builder.ArtifactData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPackageBuilder {
    private static final String PREFIX_BUNDLE = "bundle-";
    private static final String PREFIX_ARTIFACT = "artifact-";
    private static final int BUFFER_SIZE = 32768;
    private final String m_symbolicName;
    private final String m_version;
    private final List<ArtifactData> m_bundles = new ArrayList<ArtifactData>();
    private final List<ArtifactData> m_processors = new ArrayList<ArtifactData>();
    private final List<ArtifactData> m_artifacts = new ArrayList<ArtifactData>();
    private int m_id = 1;

    private DeploymentPackageBuilder(String symbolicName, String version) {
        this.m_symbolicName = symbolicName;
        this.m_version = version;
    }

    public static DeploymentPackageBuilder createDeploymentPackage(String name, String version) {
        return new DeploymentPackageBuilder(name, version);
    }

    public DeploymentPackageBuilder addBundle(URL url) throws Exception {
        return this.addBundleArtifact(url, false);
    }

    public DeploymentPackageBuilder addResourceProcessor(URL url) throws Exception {
        return this.addBundleArtifact(url, true);
    }

    public DeploymentPackageBuilder addArtifact(URL url, String processorPID) throws Exception {
        String path = url.getPath();
        int i = path.lastIndexOf(47);
        if (i > 0 && i < path.length() - 1) {
            path = path.substring(i + 1);
        }
        String name = PREFIX_ARTIFACT + this.getUniqueID() + "-" + path;
        this.m_artifacts.add(ArtifactData.createArtifact(url, name, processorPID));
        return this;
    }

    public void generate(OutputStream output) throws Exception {
        this.validateArtifacts();
        ArrayList<ArtifactData> artifacts = new ArrayList<ArtifactData>();
        artifacts.addAll(this.m_bundles);
        artifacts.addAll(this.m_processors);
        artifacts.addAll(this.m_artifacts);
        Manifest m = this.createManifest(artifacts);
        this.writeStream(artifacts, m, output);
    }

    public String getSymbolicName() {
        return this.m_symbolicName;
    }

    public String getVersion() {
        return this.m_version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DeploymentPackageBuilder addBundleArtifact(URL url, boolean isResourceProcessor) throws Exception {
        JarInputStream jis = null;
        try {
            jis = new JarInputStream(url.openStream());
            Manifest bundleManifest = jis.getManifest();
            if (bundleManifest == null) {
                throw new Exception("Not a valid manifest in: " + url);
            }
            Attributes attributes = bundleManifest.getMainAttributes();
            String bundleSymbolicName = this.getRequiredHeader(attributes, "Bundle-SymbolicName");
            String bundleVersion = this.getRequiredHeader(attributes, "Bundle-Version");
            String name = PREFIX_BUNDLE + bundleSymbolicName + "-" + bundleVersion;
            int i = name.lastIndexOf(47);
            if (i > 0 && i < name.length() - 1) {
                name = name.substring(i + 1);
            }
            if (isResourceProcessor) {
                if (!"true".equals(this.getRequiredHeader(attributes, "DeploymentPackage-Customizer"))) {
                    throw new IOException("Invalid DeploymentPackage-Customizer header in: " + url);
                }
                String processorPID = this.getRequiredHeader(attributes, "Deployment-ProvidesResourceProcessor");
                this.m_processors.add(ArtifactData.createResourceProcessor(url, name, bundleSymbolicName, bundleVersion, processorPID));
            } else {
                this.m_bundles.add(ArtifactData.createBundle(url, name, bundleSymbolicName, bundleVersion));
            }
        }
        finally {
            if (jis != null) {
                jis.close();
            }
        }
        return this;
    }

    private void validateArtifacts() throws Exception {
        for (ArtifactData data : this.m_artifacts) {
            String pid = data.getProcessorPid();
            boolean found = false;
            for (ArtifactData processor : this.m_processors) {
                if (!pid.equals(processor.getProcessorPid())) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new Exception("No resource processor found for artifact " + data.getURL() + " with processor PID " + pid);
        }
    }

    private String getRequiredHeader(Attributes mainAttributes, String headerName) throws Exception {
        String value = mainAttributes.getValue(headerName);
        if (value == null || value.equals("")) {
            throw new Exception("Missing or invalid " + headerName + " header.");
        }
        return value;
    }

    private Manifest createManifest(List<ArtifactData> files) throws Exception {
        Manifest manifest = new Manifest();
        Attributes main = manifest.getMainAttributes();
        main.putValue("Manifest-Version", "1.0");
        main.putValue("DeploymentPackage-SymbolicName", this.m_symbolicName);
        main.putValue("DeploymentPackage-Version", this.m_version);
        for (ArtifactData file : files) {
            Attributes a;
            if (file.isBundle()) {
                a = new Attributes();
                a.putValue("Bundle-SymbolicName", file.getSymbolicName());
                a.putValue("Bundle-Version", file.getVersion());
                if (file.isCustomizer()) {
                    a.putValue("DeploymentPackage-Customizer", "true");
                    a.putValue("Deployment-ProvidesResourceProcessor", file.getProcessorPid());
                }
                manifest.getEntries().put(file.getFilename(), a);
                continue;
            }
            a = new Attributes();
            a.putValue("Resource-Processor", file.getProcessorPid());
            manifest.getEntries().put(file.getFilename(), a);
        }
        return manifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStream(List<ArtifactData> files, Manifest manifest, OutputStream outputStream) throws Exception {
        JarOutputStream output = null;
        InputStream fis = null;
        try {
            output = new JarOutputStream(outputStream, manifest);
            byte[] buffer = new byte[32768];
            for (ArtifactData file : files) {
                output.putNextEntry(new ZipEntry(file.getFilename()));
                fis = file.getURL().openStream();
                int bytes = fis.read(buffer);
                while (bytes != -1) {
                    output.write(buffer, 0, bytes);
                    bytes = fis.read(buffer);
                }
                fis.close();
                output.closeEntry();
                fis = null;
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    private synchronized int getUniqueID() {
        return this.m_id++;
    }
}

