/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.builder;

import java.net.URL;

public class ArtifactData {
    private final URL m_url;
    private boolean m_isBundle;
    private String m_filename;
    private String m_bundleSymbolicName;
    private String m_bundleVersion;
    private boolean m_isCustomizer;
    private String m_processorPID;

    private ArtifactData(URL url, String filename) {
        this.m_url = url;
        this.m_filename = filename;
    }

    public static ArtifactData createBundle(URL url, String filename, String bundleSymbolicName, String bundleVersion) {
        ArtifactData data = new ArtifactData(url, filename);
        data.setBundleMetadata(bundleSymbolicName, bundleVersion);
        return data;
    }

    public static ArtifactData createResourceProcessor(URL url, String filename, String bundleSymbolicName, String bundleVersion, String processorPID) {
        ArtifactData data = new ArtifactData(url, filename);
        data.setBundleMetadata(bundleSymbolicName, bundleVersion);
        data.setResourceProcessor(processorPID);
        return data;
    }

    public static ArtifactData createArtifact(URL url, String filename, String processorPID) {
        ArtifactData data = new ArtifactData(url, filename);
        data.setArtifactResourceProcessor(processorPID);
        return data;
    }

    public URL getURL() {
        return this.m_url;
    }

    public boolean isBundle() {
        return this.m_isBundle;
    }

    public String getFilename() {
        return this.m_filename;
    }

    public String getSymbolicName() {
        return this.m_bundleSymbolicName;
    }

    public String getVersion() {
        return this.m_bundleVersion;
    }

    public boolean isCustomizer() {
        return this.m_isCustomizer;
    }

    public String getProcessorPid() {
        return this.m_processorPID;
    }

    private void setBundleMetadata(String bundleSymbolicName, String bundleVersion) {
        this.m_isBundle = true;
        this.m_bundleSymbolicName = bundleSymbolicName;
        this.m_bundleVersion = bundleVersion;
    }

    private void setResourceProcessor(String processorPID) {
        this.m_isCustomizer = true;
        this.m_processorPID = processorPID;
    }

    private void setArtifactResourceProcessor(String processorPID) {
        this.m_processorPID = processorPID;
    }
}

