/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ace.authentication.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.ace.authentication.api.AuthenticationProcessor;
import org.apache.ace.authentication.api.AuthenticationService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.useradmin.User;
import org.osgi.service.useradmin.UserAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationServiceImpl
implements AuthenticationService {
    private volatile UserAdmin m_userAdmin;
    private volatile LogService m_log;
    private final List<AuthenticationProcessorHolder> m_processors;

    public AuthenticationServiceImpl() {
        this.m_processors = new ArrayList<AuthenticationProcessorHolder>();
    }

    AuthenticationServiceImpl(LogService log) {
        this.m_log = log;
        this.m_processors = new ArrayList<AuthenticationProcessorHolder>();
    }

    @Override
    public User authenticate(Object ... context) {
        if (context == null || context.length == 0) {
            throw new IllegalArgumentException("Invalid context!");
        }
        User result = null;
        this.m_log.log(4, "Authenticating user for: " + context);
        List<AuthenticationProcessor> processors = this.getProcessors(context);
        int size = processors.size();
        for (int i = 0; i < size; ++i) {
            result = processors.get(i).authenticate(this.m_userAdmin, context);
            if (result == null) continue;
            this.m_log.log(4, "Authenticated user (" + context + ") as: " + result.getName());
            break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<AuthenticationProcessor> getProcessors(Object ... context) {
        ArrayList<AuthenticationProcessorHolder> processors;
        List<AuthenticationProcessorHolder> list = this.m_processors;
        synchronized (list) {
            processors = new ArrayList<AuthenticationProcessorHolder>(this.m_processors);
        }
        Collections.sort(processors);
        int size = processors.size();
        ArrayList<AuthenticationProcessor> result = new ArrayList<AuthenticationProcessor>(size);
        for (int i = 0; i < size; ++i) {
            AuthenticationProcessor authenticationProcessor = ((AuthenticationProcessorHolder)processors.get(i)).getAuthenticationProcessor();
            if (authenticationProcessor == null || !authenticationProcessor.canHandle(context)) continue;
            result.add(authenticationProcessor);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAuthenticationProcessor(ServiceReference serviceRef, AuthenticationProcessor processor) {
        List<AuthenticationProcessorHolder> list = this.m_processors;
        synchronized (list) {
            this.m_processors.add(new AuthenticationProcessorHolder(serviceRef, processor));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAuthenticationProcessor(ServiceReference serviceRef, AuthenticationProcessor processor) {
        List<AuthenticationProcessorHolder> list = this.m_processors;
        synchronized (list) {
            this.m_processors.remove(new AuthenticationProcessorHolder(serviceRef, processor));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AuthenticationProcessorHolder
    implements Comparable<AuthenticationProcessorHolder> {
        private final ServiceReference m_serviceRef;
        private final WeakReference<AuthenticationProcessor> m_processor;

        public AuthenticationProcessorHolder(ServiceReference serviceRef, AuthenticationProcessor processor) {
            this.m_serviceRef = serviceRef;
            this.m_processor = new WeakReference<AuthenticationProcessor>(processor);
        }

        @Override
        public int compareTo(AuthenticationProcessorHolder other) {
            ServiceReference thatServiceRef = other.m_serviceRef;
            ServiceReference thisServiceRef = this.m_serviceRef;
            return thatServiceRef.compareTo((Object)thisServiceRef);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof AuthenticationProcessorHolder)) {
                return false;
            }
            AuthenticationProcessorHolder other = (AuthenticationProcessorHolder)obj;
            return this.m_serviceRef.equals(other.m_serviceRef);
        }

        public AuthenticationProcessor getAuthenticationProcessor() {
            return (AuthenticationProcessor)this.m_processor.get();
        }

        public int hashCode() {
            return this.m_serviceRef.hashCode() ^ this.m_processor.hashCode();
        }
    }
}

