/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.trace.instrument.impl;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Tracer;

public class MilliSpan
implements Span {
    private static final Random next = new SecureRandom();
    private long start;
    private long stop;
    private final Span parent;
    private final String description;
    private final long spanId;
    private final long traceId;
    private Map<String, String> traceInfo = null;

    @Override
    public Span child(String description) {
        return new MilliSpan(description, next.nextLong(), this.traceId, this);
    }

    public MilliSpan(String description, long id, long traceId, Span parent) {
        this.description = description;
        this.spanId = id;
        this.traceId = traceId;
        this.parent = parent;
        this.start = 0L;
        this.stop = 0L;
    }

    @Override
    public synchronized void start() {
        if (this.start > 0L) {
            throw new IllegalStateException("Span for " + this.description + " has already been started");
        }
        this.start = System.currentTimeMillis();
    }

    @Override
    public synchronized void stop() {
        if (this.start == 0L) {
            throw new IllegalStateException("Span for " + this.description + " has not been started");
        }
        this.stop = System.currentTimeMillis();
        Tracer.getInstance().pop(this);
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    @Override
    public synchronized boolean running() {
        return this.start != 0L && this.stop == 0L;
    }

    @Override
    public synchronized long accumulatedMillis() {
        if (this.start == 0L) {
            return 0L;
        }
        if (this.stop > 0L) {
            return this.stop - this.start;
        }
        return this.currentTimeMillis() - this.start;
    }

    @Override
    public String toString() {
        long parentId = this.parentId();
        return "\"" + this.description() + "\" trace:" + Long.toHexString(this.traceId()) + " span:" + this.spanId + (parentId > 0L ? " parent:" + parentId : "") + " start:" + this.start + " ms: " + Long.toString(this.accumulatedMillis()) + (this.running() ? "..." : "");
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public long spanId() {
        return this.spanId;
    }

    @Override
    public Span parent() {
        return this.parent;
    }

    @Override
    public long parentId() {
        if (this.parent == null) {
            return -1L;
        }
        return this.parent.spanId();
    }

    @Override
    public long traceId() {
        return this.traceId;
    }

    @Override
    public long getStartTimeMillis() {
        return this.start;
    }

    @Override
    public long getStopTimeMillis() {
        return this.stop;
    }

    @Override
    public void data(String key, String value) {
        if (this.traceInfo == null) {
            this.traceInfo = new HashMap<String, String>();
        }
        this.traceInfo.put(key, value);
    }

    @Override
    public Map<String, String> getData() {
        if (this.traceInfo == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.traceInfo);
    }
}

