/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.start.classloader.vfs;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class MiniDFSUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeDatanodeDirectoryPermission() {
        try {
            Process p = Runtime.getRuntime().exec("/bin/sh -c umask");
            try (BufferedReader bri = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = bri.readLine();
                p.waitFor();
                if (line == null) {
                    throw new IOException("umask input stream closed prematurely");
                }
                Short umask = Short.parseShort(line.trim(), 8);
                int newPermission = 0x1FF ^ umask;
                String string = String.format("%03o", newPermission);
                return string;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error getting umask from O/S", e);
        }
    }
}

