/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest.testcases;

import java.io.IOException;
import java.util.TreeMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.YieldCallback;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestUtil;
import org.apache.accumulo.iteratortest.environments.SimpleIteratorEnvironment;
import org.apache.accumulo.iteratortest.testcases.OutputVerifyingTestCase;

public class YieldingTestCase
extends OutputVerifyingTestCase {
    @Override
    public IteratorTestOutput test(IteratorTestInput testInput) {
        SortedKeyValueIterator<Key, Value> skvi = IteratorTestUtil.instantiateIterator(testInput);
        SortedKeyValueIterator<Key, Value> source = IteratorTestUtil.createSource(testInput);
        try {
            skvi.init(source, testInput.getIteratorOptions(), (IteratorEnvironment)new SimpleIteratorEnvironment());
            YieldCallback yield = new YieldCallback();
            skvi.enableYielding(yield);
            skvi.seek(testInput.getRange(), testInput.getFamilies(), testInput.isInclusive());
            return new IteratorTestOutput(this.consume(testInput, skvi, (YieldCallback<Key>)yield));
        }
        catch (IOException e) {
            return new IteratorTestOutput(e);
        }
    }

    TreeMap<Key, Value> consume(IteratorTestInput testInput, SortedKeyValueIterator<Key, Value> skvi, YieldCallback<Key> yield) throws IOException {
        TreeMap<Key, Value> data = new TreeMap<Key, Value>();
        Key lastKey = null;
        while (yield.hasYielded() || skvi.hasTop()) {
            if (yield.hasYielded()) {
                Key yieldPosition;
                Range r = testInput.getRange();
                if (!r.contains(yieldPosition = (Key)yield.getPositionAndReset())) {
                    throw new IOException("Underlying iterator yielded to a position outside of its range: " + yieldPosition + " not in " + r);
                }
                if (skvi.hasTop()) {
                    throw new IOException("Underlying iterator reports having a top, but has yielded: " + yieldPosition);
                }
                if (lastKey != null && yieldPosition.compareTo(lastKey) <= 0) {
                    throw new IOException("Underlying iterator yielded at a position that is not past the last key returned");
                }
                skvi.seek(new Range(yieldPosition, false, r.getEndKey(), r.isEndKeyInclusive()), testInput.getFamilies(), testInput.isInclusive());
                continue;
            }
            data.put(new Key((Key)skvi.getTopKey()), new Value((Value)skvi.getTopValue()));
            skvi.next();
        }
        return data;
    }
}

