/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest.testcases;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Random;
import java.util.TreeMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestUtil;
import org.apache.accumulo.iteratortest.environments.SimpleIteratorEnvironment;
import org.apache.accumulo.iteratortest.testcases.OutputVerifyingTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReSeekTestCase
extends OutputVerifyingTestCase {
    private static final Logger log = LoggerFactory.getLogger(ReSeekTestCase.class);
    private static final int RESEEK_INTERVAL = 4;
    private final Random random = new SecureRandom();

    @Override
    public IteratorTestOutput test(IteratorTestInput testInput) {
        SortedKeyValueIterator<Key, Value> skvi = IteratorTestUtil.instantiateIterator(testInput);
        SortedKeyValueIterator<Key, Value> source = IteratorTestUtil.createSource(testInput);
        try {
            skvi.init(source, testInput.getIteratorOptions(), (IteratorEnvironment)new SimpleIteratorEnvironment());
            skvi.seek(testInput.getRange(), testInput.getFamilies(), testInput.isInclusive());
            return new IteratorTestOutput(this.consume(skvi, testInput));
        }
        catch (IOException e) {
            return new IteratorTestOutput(e);
        }
    }

    TreeMap<Key, Value> consume(SortedKeyValueIterator<Key, Value> skvi, IteratorTestInput testInput) throws IOException {
        TreeMap<Key, Value> data = new TreeMap<Key, Value>();
        Range origRange = testInput.getRange();
        Collection<ByteSequence> origFamilies = testInput.getFamilies();
        boolean origInclusive = testInput.isInclusive();
        int reseekCount = this.random.nextInt(4);
        int i = 0;
        while (skvi.hasTop()) {
            data.put(new Key((Key)skvi.getTopKey()), new Value((Value)skvi.getTopValue()));
            if (i % 4 == reseekCount) {
                Key reSeekStartKey = (Key)skvi.getTopKey();
                skvi = IteratorTestUtil.instantiateIterator(testInput);
                SortedKeyValueIterator<Key, Value> sourceCopy = IteratorTestUtil.createSource(testInput);
                skvi.init(sourceCopy, testInput.getIteratorOptions(), (IteratorEnvironment)new SimpleIteratorEnvironment());
                Range newRange = new Range(reSeekStartKey, false, origRange.getEndKey(), origRange.isEndKeyInclusive());
                log.debug("Re-seeking to {}", (Object)newRange);
                skvi.seek(newRange, origFamilies, origInclusive);
            } else {
                skvi.next();
            }
            ++i;
        }
        return data;
    }
}

