/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest.testcases;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import java.util.TreeMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestUtil;
import org.apache.accumulo.iteratortest.environments.SimpleIteratorEnvironment;
import org.apache.accumulo.iteratortest.testcases.OutputVerifyingTestCase;

public class MultipleHasTopCalls
extends OutputVerifyingTestCase {
    private final Random random = new SecureRandom();

    @Override
    public IteratorTestOutput test(IteratorTestInput testInput) {
        SortedKeyValueIterator<Key, Value> skvi = IteratorTestUtil.instantiateIterator(testInput);
        SortedKeyValueIterator<Key, Value> source = IteratorTestUtil.createSource(testInput);
        try {
            skvi.init(source, testInput.getIteratorOptions(), (IteratorEnvironment)new SimpleIteratorEnvironment());
            skvi.seek(testInput.getRange(), testInput.getFamilies(), testInput.isInclusive());
            return new IteratorTestOutput(this.consume(skvi));
        }
        catch (IOException e) {
            return new IteratorTestOutput(e);
        }
    }

    TreeMap<Key, Value> consume(SortedKeyValueIterator<Key, Value> skvi) throws IOException {
        int i;
        TreeMap<Key, Value> data = new TreeMap<Key, Value>();
        while (skvi.hasTop()) {
            for (i = 0; i < this.random.nextInt(5) + 1; ++i) {
                if (skvi.hasTop()) continue;
                throw this.badStateException(true);
            }
            data.put(new Key((Key)skvi.getTopKey()), new Value((Value)skvi.getTopValue()));
            skvi.next();
        }
        for (i = 0; i < this.random.nextInt(5) + 1; ++i) {
            if (!skvi.hasTop()) continue;
            throw this.badStateException(false);
        }
        return data;
    }

    IllegalStateException badStateException(boolean expectedState) {
        return new IllegalStateException("Multiple sequential calls to hasTop should not alter the state or return value of the iterator. Expected '" + expectedState + ", but got '" + !expectedState + "'.");
    }
}

