/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest.testcases;

import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import java.util.TreeMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestUtil;
import org.apache.accumulo.iteratortest.environments.SimpleIteratorEnvironment;
import org.apache.accumulo.iteratortest.testcases.OutputVerifyingTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsolatedDeepCopiesTestCase
extends OutputVerifyingTestCase {
    private static final Logger log = LoggerFactory.getLogger(IsolatedDeepCopiesTestCase.class);
    private final Random random = new SecureRandom();

    @Override
    public IteratorTestOutput test(IteratorTestInput testInput) {
        SortedKeyValueIterator<Key, Value> skvi = IteratorTestUtil.instantiateIterator(testInput);
        SortedKeyValueIterator<Key, Value> source = IteratorTestUtil.createSource(testInput);
        try {
            skvi.init(source, testInput.getIteratorOptions(), (IteratorEnvironment)new SimpleIteratorEnvironment());
            SortedKeyValueIterator copy1 = skvi.deepCopy((IteratorEnvironment)new SimpleIteratorEnvironment());
            SortedKeyValueIterator copy2 = copy1.deepCopy((IteratorEnvironment)new SimpleIteratorEnvironment());
            Range seekRange = testInput.getRange();
            Collection<ByteSequence> seekColumnFamilies = testInput.getFamilies();
            boolean seekInclusive = testInput.isInclusive();
            skvi.seek(testInput.getRange(), seekColumnFamilies, seekInclusive);
            copy1.seek(testInput.getRange(), seekColumnFamilies, seekInclusive);
            copy2.seek(testInput.getRange(), seekColumnFamilies, seekInclusive);
            TreeMap<Key, Value> output = this.consumeMany(new ArrayList<SortedKeyValueIterator<Key, Value>>(Arrays.asList(skvi, copy1, copy2)), seekRange, seekColumnFamilies, seekInclusive);
            return new IteratorTestOutput(output);
        }
        catch (IOException e) {
            return new IteratorTestOutput(e);
        }
    }

    TreeMap<Key, Value> consumeMany(Collection<SortedKeyValueIterator<Key, Value>> iterators, Range range, Collection<ByteSequence> seekColumnFamilies, boolean seekInclusive) throws IOException {
        TreeMap<Key, Value> data = new TreeMap<Key, Value>();
        while (this.allHasTop(iterators)) {
            if (this.random.nextInt(3) == 0) {
                log.debug("Deep-copying and re-seeking an iterator");
                SortedKeyValueIterator newcopy = this.getRandomElement(iterators).deepCopy((IteratorEnvironment)new SimpleIteratorEnvironment());
                newcopy.seek(new Range(this.getTopKey(iterators), true, range.getEndKey(), range.isEndKeyInclusive()), seekColumnFamilies, seekInclusive);
                iterators.add((SortedKeyValueIterator<Key, Value>)newcopy);
            }
            data.put(this.getTopKey(iterators), this.getTopValue(iterators));
            this.next(iterators);
        }
        for (SortedKeyValueIterator<Key, Value> iter : iterators) {
            if (!iter.hasTop()) continue;
            return null;
        }
        return data;
    }

    private <E> E getRandomElement(Collection<E> iterators) {
        if (iterators == null || iterators.size() == 0) {
            throw new IllegalArgumentException("should not pass an empty collection");
        }
        int num = this.random.nextInt(iterators.size());
        for (E e : iterators) {
            if (num-- != 0) continue;
            return e;
        }
        throw new AssertionError();
    }

    boolean allHasTop(Collection<SortedKeyValueIterator<Key, Value>> iterators) {
        for (SortedKeyValueIterator<Key, Value> iter : iterators) {
            if (iter.hasTop()) continue;
            return false;
        }
        return true;
    }

    Key getTopKey(Collection<SortedKeyValueIterator<Key, Value>> iterators) {
        boolean first = true;
        Key topKey = null;
        for (SortedKeyValueIterator<Key, Value> iter : iterators) {
            if (first) {
                topKey = (Key)iter.getTopKey();
                first = false;
                continue;
            }
            if (topKey.equals((Object)iter.getTopKey())) continue;
            throw new IllegalStateException("Inconsistent keys between two iterators: " + topKey + " " + iter.getTopKey());
        }
        return new Key(topKey);
    }

    Value getTopValue(Collection<SortedKeyValueIterator<Key, Value>> iterators) {
        boolean first = true;
        Value topValue = null;
        for (SortedKeyValueIterator<Key, Value> iter : iterators) {
            if (first) {
                topValue = (Value)iter.getTopValue();
                first = false;
                continue;
            }
            if (topValue.equals((Object)iter.getTopValue())) continue;
            throw new IllegalStateException("Inconsistent values between two iterators: " + topValue + " " + iter.getTopValue());
        }
        if (topValue == null) {
            throw new IllegalStateException("Should always find a non-null Value from the iterator being tested.");
        }
        return new Value(topValue);
    }

    void next(Collection<SortedKeyValueIterator<Key, Value>> iterators) throws IOException {
        for (SortedKeyValueIterator<Key, Value> iter : iterators) {
            iter.next();
        }
    }
}

