/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest.testcases;

import java.io.IOException;
import java.util.TreeMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestUtil;
import org.apache.accumulo.iteratortest.environments.SimpleIteratorEnvironment;
import org.apache.accumulo.iteratortest.testcases.OutputVerifyingTestCase;

public class DeepCopyTestCase
extends OutputVerifyingTestCase {
    @Override
    public IteratorTestOutput test(IteratorTestInput testInput) {
        SortedKeyValueIterator<Key, Value> skvi = IteratorTestUtil.instantiateIterator(testInput);
        SortedKeyValueIterator<Key, Value> source = IteratorTestUtil.createSource(testInput);
        try {
            skvi.init(source, testInput.getIteratorOptions(), (IteratorEnvironment)new SimpleIteratorEnvironment());
            SortedKeyValueIterator copy = skvi.deepCopy((IteratorEnvironment)new SimpleIteratorEnvironment());
            copy.seek(testInput.getRange(), testInput.getFamilies(), testInput.isInclusive());
            return new IteratorTestOutput(this.consume((SortedKeyValueIterator<Key, Value>)copy));
        }
        catch (IOException e) {
            return new IteratorTestOutput(e);
        }
    }

    TreeMap<Key, Value> consume(SortedKeyValueIterator<Key, Value> skvi) throws IOException {
        TreeMap<Key, Value> data = new TreeMap<Key, Value>();
        while (skvi.hasTop()) {
            data.put(new Key((Key)skvi.getTopKey()), new Value((Value)skvi.getTopValue()));
            skvi.next();
        }
        return data;
    }
}

