/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest.junit4;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestReport;
import org.apache.accumulo.iteratortest.IteratorTestRunner;
import org.apache.accumulo.iteratortest.testcases.IteratorTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class BaseJUnit4IteratorTest {
    private static final Logger log = LoggerFactory.getLogger(BaseJUnit4IteratorTest.class);
    public final IteratorTestRunner runner;

    public BaseJUnit4IteratorTest(IteratorTestInput input, IteratorTestOutput expectedOutput, IteratorTestCase testCase) {
        this.runner = new IteratorTestRunner(input, expectedOutput, Collections.singleton(testCase));
    }

    public static Object[][] createParameters(IteratorTestInput input, IteratorTestOutput output, Collection<IteratorTestCase> testCases) {
        Object[][] parameters = new Object[testCases.size()][3];
        Iterator<IteratorTestCase> testCaseIter = testCases.iterator();
        int i = 0;
        while (testCaseIter.hasNext()) {
            IteratorTestCase testCase = testCaseIter.next();
            parameters[i] = new Object[]{input, output, testCase};
            ++i;
        }
        return parameters;
    }

    @Test
    public void testIterator() {
        List<IteratorTestReport> reports = this.runner.runTests();
        Assert.assertEquals((long)1L, (long)reports.size());
        IteratorTestReport report = reports.get(0);
        Assert.assertNotNull((Object)report);
        Assert.assertTrue((String)report.getSummary(), (boolean)report.didTestSucceed());
        log.trace("Expected: {}, Actual: {}", (Object)report.getExpectedOutput(), (Object)report.getActualOutput());
    }
}

