/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class SimpleKVReusingIterator
implements SortedKeyValueIterator<Key, Value> {
    private final SortedKeyValueIterator<Key, Value> source;
    private final Key topKey = new Key();
    private final Value topValue = new Value();

    public SimpleKVReusingIterator(SortedKeyValueIterator<Key, Value> source) {
        this.source = source;
    }

    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        this.source.init(source, options, env);
    }

    public boolean hasTop() {
        return this.source.hasTop();
    }

    public void next() throws IOException {
        this.source.next();
        this.load();
    }

    public void seek(Range range, Collection<ByteSequence> columnFamilies, boolean inclusive) throws IOException {
        this.source.seek(range, columnFamilies, inclusive);
        this.load();
    }

    public Key getTopKey() {
        return this.topKey;
    }

    public Value getTopValue() {
        return this.topValue;
    }

    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        SortedKeyValueIterator newSource = this.source.deepCopy(env);
        return new SimpleKVReusingIterator((SortedKeyValueIterator<Key, Value>)newSource);
    }

    private void load() {
        if (this.hasTop()) {
            this.topKey.set((Key)this.source.getTopKey());
            this.topValue.set(((Value)this.source.getTopValue()).get());
        }
    }
}

