/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.IteratorTestReport;
import org.apache.accumulo.iteratortest.testcases.IteratorTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorTestRunner {
    private static final Logger log = LoggerFactory.getLogger(IteratorTestRunner.class);
    private final IteratorTestInput testInput;
    private final IteratorTestOutput testOutput;
    private final Collection<IteratorTestCase> testCases;

    public IteratorTestRunner(IteratorTestInput testInput, IteratorTestOutput testOutput, Collection<IteratorTestCase> testCases) {
        this.testInput = testInput;
        this.testOutput = testOutput;
        this.testCases = testCases;
    }

    public IteratorTestInput getTestInput() {
        return this.testInput;
    }

    public IteratorTestOutput getTestOutput() {
        return this.testOutput;
    }

    public Collection<IteratorTestCase> getTestCases() {
        return this.testCases;
    }

    public List<IteratorTestReport> runTests() {
        ArrayList<IteratorTestReport> testReports = new ArrayList<IteratorTestReport>(this.testCases.size());
        for (IteratorTestCase testCase : this.testCases) {
            IteratorTestOutput actualOutput;
            log.info("Invoking {} on {}", (Object)testCase.getClass().getName(), (Object)this.testInput.getIteratorClass().getName());
            try {
                actualOutput = testCase.test(this.testInput);
            }
            catch (Exception e) {
                log.error("Failed to invoke {} on {}", new Object[]{testCase.getClass().getName(), this.testInput.getIteratorClass().getName(), e});
                actualOutput = new IteratorTestOutput(e);
            }
            if (actualOutput == null) {
                throw new IllegalStateException("IteratorTestCase implementations should always return a non-null IteratorTestOutput. " + testCase.getClass().getName() + " did not!");
            }
            testReports.add(new IteratorTestReport(this.testInput, this.testOutput, actualOutput, testCase));
        }
        return testReports;
    }
}

