/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest;

import java.util.Objects;
import org.apache.accumulo.iteratortest.IteratorTestInput;
import org.apache.accumulo.iteratortest.IteratorTestOutput;
import org.apache.accumulo.iteratortest.testcases.IteratorTestCase;

public class IteratorTestReport {
    private final IteratorTestInput input;
    private final IteratorTestOutput expectedOutput;
    private final IteratorTestCase testCase;
    private final IteratorTestOutput actualOutput;

    public IteratorTestReport(IteratorTestInput input, IteratorTestOutput expectedOutput, IteratorTestOutput actualOutput, IteratorTestCase testCase) {
        this.input = Objects.requireNonNull(input);
        this.expectedOutput = Objects.requireNonNull(expectedOutput);
        this.testCase = Objects.requireNonNull(testCase);
        this.actualOutput = Objects.requireNonNull(actualOutput);
    }

    public IteratorTestInput getInput() {
        return this.input;
    }

    public IteratorTestOutput getExpectedOutput() {
        return this.expectedOutput;
    }

    public IteratorTestCase getTestCase() {
        return this.testCase;
    }

    public IteratorTestOutput getActualOutput() {
        return this.actualOutput;
    }

    public boolean didTestSucceed() {
        return this.testCase.verify(this.expectedOutput, this.actualOutput);
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("IteratorTestReport Summary: \n").append("\tTest Case = ").append(this.testCase.getClass().getName()).append("\tInput Data = '").append(this.input).append("'\n").append("\tExpected Output = '").append(this.expectedOutput).append("'\n").append("\tActual Output = '").append(this.actualOutput).append("'\n");
        return sb.toString();
    }
}

