/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest;

import java.util.Collections;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;

public class IteratorTestOutput {
    private final SortedMap<Key, Value> output;
    private final Exception exception;
    private final TestOutcome outcome;

    public IteratorTestOutput(TestOutcome outcome) {
        this.outcome = outcome;
        if (outcome == TestOutcome.COMPLETED) {
            throw new IllegalArgumentException("This constructor is only for use with PASSED and FAILED");
        }
        this.output = null;
        this.exception = null;
    }

    public IteratorTestOutput(SortedMap<Key, Value> output) {
        this.output = Collections.unmodifiableSortedMap(Objects.requireNonNull(output));
        this.exception = null;
        this.outcome = TestOutcome.COMPLETED;
    }

    public IteratorTestOutput(Exception e) {
        this.output = null;
        this.exception = Objects.requireNonNull(e);
        this.outcome = TestOutcome.FAILED;
    }

    public TestOutcome getTestOutcome() {
        return this.outcome;
    }

    public SortedMap<Key, Value> getOutput() {
        return this.output;
    }

    public boolean hasOutput() {
        return this.output != null;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.exception == null ? 0 : this.exception.hashCode());
        result = 31 * result + (this.outcome == null ? 0 : this.outcome.hashCode());
        result = 31 * result + (this.output == null ? 0 : this.output.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IteratorTestOutput)) {
            return false;
        }
        IteratorTestOutput other = (IteratorTestOutput)o;
        if (this.outcome != other.outcome) {
            return false;
        }
        if (this.hasOutput()) {
            if (!other.hasOutput()) {
                return false;
            }
            return this.output.equals(other.output);
        }
        if (!other.hasException()) {
            return false;
        }
        return this.exception.equals(other.getException());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[outcome=").append((Object)this.outcome).append(", output='").append(this.output).append("', exception=").append(this.exception).append("]");
        return sb.toString();
    }

    public static enum TestOutcome {
        PASSED,
        FAILED,
        COMPLETED;

    }
}

