/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.accumulo.core.data.ByteSequence;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public class IteratorTestInput {
    private final Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass;
    private final Map<String, String> iteratorOptions;
    private final Range range;
    private final Collection<ByteSequence> families;
    private final boolean inclusive;
    private final SortedMap<Key, Value> input;

    public IteratorTestInput(Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass, Map<String, String> iteratorOptions, Range range, SortedMap<Key, Value> input) {
        this(iteratorClass, iteratorOptions, range, input, Collections.emptySet(), false);
    }

    public IteratorTestInput(Class<? extends SortedKeyValueIterator<Key, Value>> iteratorClass, Map<String, String> iteratorOptions, Range range, SortedMap<Key, Value> input, Collection<ByteSequence> families, boolean inclusive) {
        this.iteratorClass = Objects.requireNonNull(iteratorClass);
        this.iteratorOptions = Collections.unmodifiableMap(Objects.requireNonNull(iteratorOptions));
        this.range = Objects.requireNonNull(range);
        this.input = Collections.unmodifiableSortedMap(Objects.requireNonNull(input));
        this.families = Collections.unmodifiableCollection(Objects.requireNonNull(families));
        this.inclusive = inclusive;
    }

    public Class<? extends SortedKeyValueIterator<Key, Value>> getIteratorClass() {
        return this.iteratorClass;
    }

    public Map<String, String> getIteratorOptions() {
        return this.iteratorOptions;
    }

    public Range getRange() {
        return this.range;
    }

    public Collection<ByteSequence> getFamilies() {
        return this.families;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public SortedMap<Key, Value> getInput() {
        return this.input;
    }

    public String toString() {
        return "[iteratorClass=" + this.iteratorClass + ", iteratorOptions=" + this.iteratorOptions + ", range=" + this.range + ", families=" + this.families + ", inclusive=" + this.inclusive + ", input='" + this.input + "']";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IteratorTestInput)) {
            return false;
        }
        IteratorTestInput that = (IteratorTestInput)o;
        return this.inclusive == that.inclusive && this.iteratorClass.equals(that.iteratorClass) && this.iteratorOptions.equals(that.iteratorOptions) && this.range.equals(that.range) && this.families.equals(that.families) && this.input.equals(that.input);
    }

    public int hashCode() {
        int result = this.iteratorClass.hashCode();
        result = 31 * result + this.iteratorOptions.hashCode();
        result = 31 * result + this.range.hashCode();
        result = 31 * result + this.families.hashCode();
        result = 31 * result + (this.inclusive ? 1 : 0);
        result = 31 * result + this.input.hashCode();
        return result;
    }
}

