/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.iteratortest;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.iteratortest.testcases.IteratorTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorTestCaseFinder {
    private static final Logger log = LoggerFactory.getLogger(IteratorTestCaseFinder.class);

    public static List<IteratorTestCase> findAllTestCases() {
        ClassPath cp;
        log.info("Searching {}", (Object)IteratorTestCase.class.getPackage().getName());
        try {
            cp = ClassPath.from((ClassLoader)IteratorTestCaseFinder.class.getClassLoader());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ImmutableSet classes = cp.getTopLevelClasses(IteratorTestCase.class.getPackage().getName());
        ArrayList<IteratorTestCase> testCases = new ArrayList<IteratorTestCase>();
        for (ClassPath.ClassInfo classInfo : classes) {
            Class<?> clz;
            try {
                clz = Class.forName(classInfo.getName());
            }
            catch (Exception e) {
                log.warn("Could not get class for " + classInfo.getName(), (Throwable)e);
                continue;
            }
            if (clz.isInterface() || Modifier.isAbstract(clz.getModifiers()) || !IteratorTestCase.class.isAssignableFrom(clz)) {
                log.debug("Skipping " + clz);
                continue;
            }
            try {
                testCases.add((IteratorTestCase)clz.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                log.warn("Could not instantiate {}", clz, (Object)e);
            }
        }
        return testCases;
    }
}

