/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce.lib;

import com.beust.jcommander.Parameter;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.hadoop.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.hadoop.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.MapReduceClientOpts;
import org.apache.hadoop.mapreduce.Job;

public class MapReduceClientOnDefaultTable
extends MapReduceClientOpts {
    @Parameter(names={"--table"}, description="table to use")
    public String tableName;

    public MapReduceClientOnDefaultTable(String table) {
        this.tableName = table;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setAccumuloConfigs(Job job) throws AccumuloException, AccumuloSecurityException {
        String tableName = this.getTableName();
        Properties clientProps = this.getClientProperties();
        AccumuloInputFormat.configure().clientProperties(clientProps).table(tableName).auths(this.auths).store(job);
        AccumuloOutputFormat.configure().clientProperties(clientProps).defaultTable(tableName).createTables(true).store(job);
    }
}

