/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MultiTableBatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.hadoop.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.OutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccumuloRecordWriter
extends RecordWriter<Text, Mutation> {
    private static final Class<AccumuloOutputFormat> CLASS = AccumuloOutputFormat.class;
    private static final Logger log = LoggerFactory.getLogger(AccumuloRecordWriter.class);
    private MultiTableBatchWriter mtbw = null;
    private final HashMap<Text, BatchWriter> bws;
    private Text defaultTableName;
    private boolean simulate;
    private boolean createTables;
    private long mutCount = 0L;
    private long valCount = 0L;
    private AccumuloClient client;

    public AccumuloRecordWriter(TaskAttemptContext context) {
        Configuration conf = context.getConfiguration();
        this.simulate = OutputConfigurator.getSimulationMode(CLASS, conf);
        this.createTables = OutputConfigurator.canCreateTables(CLASS, conf);
        if (this.simulate) {
            log.info("Simulating output only. No writes to tables will occur");
        }
        this.bws = new HashMap();
        String tname = OutputConfigurator.getDefaultTableName(CLASS, conf);
        Text text = this.defaultTableName = tname == null ? null : new Text(tname);
        if (!this.simulate) {
            this.client = OutputConfigurator.createClient(CLASS, conf);
            this.mtbw = this.client.createMultiTableBatchWriter();
        }
    }

    public void write(Text table, Mutation mutation) throws IOException {
        if (table == null || table.toString().isEmpty()) {
            table = this.defaultTableName;
        }
        if (!this.simulate && table == null) {
            throw new IOException("No table or default table specified. Try simulation mode next time");
        }
        ++this.mutCount;
        this.valCount += (long)mutation.size();
        this.printMutation(table, mutation);
        if (this.simulate) {
            return;
        }
        if (!this.bws.containsKey(table)) {
            try {
                this.addTable(table);
            }
            catch (Exception e) {
                log.error("Could not add table '" + table + "'", (Throwable)e);
                throw new IOException(e);
            }
        }
        try {
            this.bws.get(table).addMutation(mutation);
        }
        catch (MutationsRejectedException e) {
            throw new IOException(e);
        }
    }

    public void addTable(Text tableName) throws AccumuloException, AccumuloSecurityException {
        if (this.simulate) {
            log.info("Simulating adding table: " + tableName);
            return;
        }
        log.debug("Adding table: " + tableName);
        BatchWriter bw = null;
        String table = tableName.toString();
        if (this.createTables && !this.client.tableOperations().exists(table)) {
            try {
                this.client.tableOperations().create(table);
            }
            catch (AccumuloSecurityException e) {
                log.error("Accumulo security violation creating " + table, (Throwable)e);
                throw e;
            }
            catch (TableExistsException e) {
                // empty catch block
            }
        }
        try {
            bw = this.mtbw.getBatchWriter(table);
        }
        catch (TableNotFoundException e) {
            log.error("Accumulo table " + table + " doesn't exist and cannot be created.", (Throwable)e);
            throw new AccumuloException((Throwable)e);
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw e;
        }
        if (bw != null) {
            this.bws.put(tableName, bw);
        }
    }

    private int printMutation(Text table, Mutation m) {
        if (log.isTraceEnabled()) {
            log.trace(String.format("Table %s row key: %s", table, this.hexDump(m.getRow())));
            for (ColumnUpdate cu : m.getUpdates()) {
                log.trace(String.format("Table %s column: %s:%s", table, this.hexDump(cu.getColumnFamily()), this.hexDump(cu.getColumnQualifier())));
                log.trace(String.format("Table %s security: %s", table, new ColumnVisibility(cu.getColumnVisibility()).toString()));
                log.trace(String.format("Table %s value: %s", table, this.hexDump(cu.getValue())));
            }
        }
        return m.getUpdates().size();
    }

    private String hexDump(byte[] ba) {
        StringBuilder sb = new StringBuilder();
        for (byte b : ba) {
            if (b > 32 && b < 126) {
                sb.append((char)b);
                continue;
            }
            sb.append(String.format("x%02x", b));
        }
        return sb.toString();
    }

    public void close(TaskAttemptContext attempt) throws IOException {
        log.debug("mutations written: " + this.mutCount + ", values written: " + this.valCount);
        if (this.simulate) {
            return;
        }
        try {
            this.mtbw.close();
        }
        catch (MutationsRejectedException e) {
            if (e.getSecurityErrorCodes().size() >= 0) {
                HashMap tables = new HashMap();
                for (Map.Entry ke : e.getSecurityErrorCodes().entrySet()) {
                    String tableId = ((TabletId)ke.getKey()).getTableId().toString();
                    HashSet secCodes = (HashSet)tables.get(tableId);
                    if (secCodes == null) {
                        secCodes = new HashSet();
                        tables.put(tableId, secCodes);
                    }
                    secCodes.addAll((Collection)ke.getValue());
                }
                log.error("Not authorized to write to tables : " + tables);
            }
            if (e.getConstraintViolationSummaries().size() > 0) {
                log.error("Constraint violations : " + e.getConstraintViolationSummaries().size());
            }
            throw new IOException(e);
        }
        finally {
            this.client.close();
        }
    }
}

