/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapreduce;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.OfflineScanner;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.hadoopImpl.mapreduce.BatchInputSplit;
import org.apache.accumulo.hadoopImpl.mapreduce.InputTableConfig;
import org.apache.accumulo.hadoopImpl.mapreduce.RangeInputSplit;
import org.apache.accumulo.hadoopImpl.mapreduce.SplitUtils;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.InputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccumuloRecordReader<K, V>
extends RecordReader<K, V> {
    private static final Logger log = LoggerFactory.getLogger(AccumuloRecordReader.class);
    private final Class<?> CLASS;
    protected long numKeysRead;
    protected AccumuloClient client;
    protected Iterator<Map.Entry<Key, Value>> scannerIterator;
    protected ScannerBase scannerBase;
    protected RangeInputSplit split;
    protected K currentK = null;
    protected V currentV = null;
    protected Key currentKey = null;

    public AccumuloRecordReader(Class<?> callingClass) {
        this.CLASS = callingClass;
    }

    private List<IteratorSetting> contextIterators(TaskAttemptContext context) {
        return InputConfigurator.getIterators(this.CLASS, context.getConfiguration());
    }

    private void setupIterators(TaskAttemptContext context, ScannerBase scanner, RangeInputSplit split) {
        List<IteratorSetting> iterators = null;
        if (split == null) {
            iterators = this.contextIterators(context);
        } else {
            iterators = split.getIterators();
            if (iterators == null) {
                iterators = this.contextIterators(context);
            }
        }
        for (IteratorSetting iterator : iterators) {
            scanner.addScanIterator(iterator);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
        void var11_18;
        Map<String, String> map;
        this.split = (RangeInputSplit)inSplit;
        log.debug("Initializing input split: " + (Object)((Object)this.split));
        Configuration conf = attempt.getConfiguration();
        this.client = AccumuloRecordReader.createClient((JobContext)attempt, this.CLASS);
        ClientContext context = (ClientContext)this.client;
        Authorizations authorizations = InputConfigurator.getScanAuthorizations(this.CLASS, conf);
        String classLoaderContext = InputConfigurator.getClassLoaderContext(this.CLASS, conf);
        String table = this.split.getTableName();
        InputTableConfig tableConfig = InputConfigurator.getInputTableConfig(this.CLASS, conf, this.split.getTableName());
        log.debug("Creating client with user: " + this.client.whoami());
        log.debug("Creating scanner for table: " + table);
        log.debug("Authorizations are: " + authorizations);
        if (this.split instanceof BatchInputSplit) {
            BatchScanner scanner;
            BatchInputSplit batchSplit = (BatchInputSplit)this.split;
            try {
                int n = 1;
                scanner = context.createBatchScanner(this.split.getTableName(), authorizations, n);
                this.setupIterators(attempt, (ScannerBase)scanner, this.split);
                if (classLoaderContext != null) {
                    scanner.setClassLoaderContext(classLoaderContext);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IOException(exception);
            }
            scanner.setRanges(batchSplit.getRanges());
            this.scannerBase = scanner;
        } else {
            Object scanner;
            Boolean usesLocalIterators;
            Boolean bl;
            Object isOffline = this.split.isOffline();
            if (isOffline == null) {
                isOffline = tableConfig.isOfflineScan();
            }
            if ((bl = this.split.isIsolatedScan()) == null) {
                Boolean bl2 = tableConfig.shouldUseIsolatedScanners();
            }
            if ((usesLocalIterators = this.split.usesLocalIterators()) == null) {
                usesLocalIterators = tableConfig.shouldUseLocalIterators();
            }
            try {
                void var11_14;
                scanner = ((Boolean)isOffline).booleanValue() ? new OfflineScanner(context, Table.ID.of((String)this.split.getTableId()), authorizations) : new ScannerImpl(context, Table.ID.of((String)this.split.getTableId()), authorizations);
                if (var11_14.booleanValue()) {
                    log.info("Creating isolated scanner");
                    scanner = new IsolatedScanner((Scanner)scanner);
                }
                if (usesLocalIterators.booleanValue()) {
                    log.info("Using local iterators");
                    scanner = new ClientSideIteratorScanner((Scanner)scanner);
                }
                this.setupIterators(attempt, (ScannerBase)scanner, this.split);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            scanner.setRange(this.split.getRange());
            this.scannerBase = scanner;
        }
        Collection<IteratorSetting.Column> columns = this.split.getFetchedColumns();
        if (columns == null) {
            columns = tableConfig.getFetchedColumns();
        }
        for (Pair pair : columns) {
            if (pair.getSecond() != null) {
                log.debug("Fetching column " + pair.getFirst() + ":" + pair.getSecond());
                this.scannerBase.fetchColumn((Text)pair.getFirst(), (Text)pair.getSecond());
                continue;
            }
            log.debug("Fetching column family " + pair.getFirst());
            this.scannerBase.fetchColumnFamily((Text)pair.getFirst());
        }
        SamplerConfiguration samplerConfig = this.split.getSamplerConfiguration();
        if (samplerConfig == null) {
            samplerConfig = tableConfig.getSamplerConfiguration();
        }
        if (samplerConfig != null) {
            this.scannerBase.setSamplerConfiguration(samplerConfig);
        }
        if ((map = this.split.getExecutionHints()) == null || map.isEmpty()) {
            Map<String, String> map2 = tableConfig.getExecutionHints();
        }
        if (var11_18 != null) {
            this.scannerBase.setExecutionHints((Map)var11_18);
        }
        this.scannerIterator = this.scannerBase.iterator();
        this.numKeysRead = 0L;
    }

    public void close() {
        if (this.scannerBase != null) {
            this.scannerBase.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    public float getProgress() {
        if (this.numKeysRead > 0L && this.currentKey == null) {
            return 1.0f;
        }
        return this.split.getProgress(this.currentKey);
    }

    public K getCurrentKey() {
        return this.currentK;
    }

    public V getCurrentValue() {
        return this.currentV;
    }

    private static void validateOptions(JobContext context, Class<?> callingClass) throws IOException {
        try (AccumuloClient client = InputConfigurator.createClient(callingClass, context.getConfiguration());){
            InputConfigurator.validatePermissions(callingClass, context.getConfiguration(), client);
        }
    }

    private static Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobContext context, Table.ID tableId, List<Range> ranges, Class<?> callingClass) throws TableNotFoundException, AccumuloException {
        try (AccumuloClient client = AccumuloRecordReader.createClient(context, callingClass);){
            Map<String, Map<KeyExtent, List<Range>>> map = InputConfigurator.binOffline(tableId, ranges, (ClientContext)client);
            return map;
        }
    }

    public static List<InputSplit> getSplits(JobContext context, Class<?> callingClass) throws IOException {
        AccumuloRecordReader.validateOptions(context, callingClass);
        SecureRandom random = new SecureRandom();
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        try (AccumuloClient client = AccumuloRecordReader.createClient(context, callingClass);){
            Map<String, InputTableConfig> tableConfigs = InputConfigurator.getInputTableConfigs(callingClass, context.getConfiguration());
            for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
                ArrayList<Range> ranges;
                boolean supportBatchScan;
                Table.ID tableId;
                String tableName = tableConfigEntry.getKey();
                InputTableConfig tableConfig = tableConfigEntry.getValue();
                ClientContext clientContext = (ClientContext)client;
                try {
                    tableId = Tables.getTableId((ClientContext)clientContext, (String)tableName);
                }
                catch (TableNotFoundException e) {
                    throw new IOException(e);
                }
                boolean batchScan = InputConfigurator.isBatchScan(callingClass, context.getConfiguration());
                boolean bl = supportBatchScan = !tableConfig.isOfflineScan() && !tableConfig.shouldUseIsolatedScanners() && !tableConfig.shouldUseLocalIterators();
                if (batchScan && !supportBatchScan) {
                    throw new IllegalArgumentException("BatchScanner optimization not available for offline scan, isolated, or local iterators");
                }
                boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
                if (batchScan && !autoAdjust) {
                    throw new IllegalArgumentException("AutoAdjustRanges must be enabled when using BatchScanner optimization");
                }
                ArrayList<Range> arrayList = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
                if (ranges.isEmpty()) {
                    ranges = new ArrayList<Range>(1);
                    ranges.add(new Range());
                }
                Map<Object, Object> binnedRanges = new HashMap();
                try {
                    if (tableConfig.isOfflineScan()) {
                        binnedRanges = AccumuloRecordReader.binOfflineTable(context, tableId, ranges, callingClass);
                        while (binnedRanges == null) {
                            UtilWaitThread.sleepUninterruptibly((long)(100 + random.nextInt(100)), (TimeUnit)TimeUnit.MILLISECONDS);
                            binnedRanges = AccumuloRecordReader.binOfflineTable(context, tableId, ranges, callingClass);
                        }
                    } else {
                        TabletLocator tl = InputConfigurator.getTabletLocator(callingClass, context.getConfiguration(), tableId);
                        tl.invalidateCache();
                        while (!tl.binRanges(clientContext, ranges, binnedRanges).isEmpty()) {
                            String tableIdStr = tableId.canonicalID();
                            if (!Tables.exists((ClientContext)clientContext, (Table.ID)tableId)) {
                                throw new TableDeletedException(tableIdStr);
                            }
                            if (Tables.getTableState((ClientContext)clientContext, (Table.ID)tableId) == TableState.OFFLINE) {
                                throw new TableOfflineException(Tables.getTableOfflineMsg((ClientContext)clientContext, (Table.ID)tableId));
                            }
                            binnedRanges.clear();
                            log.warn("Unable to locate bins for specified ranges. Retrying.");
                            UtilWaitThread.sleepUninterruptibly((long)(100 + random.nextInt(100)), (TimeUnit)TimeUnit.MILLISECONDS);
                            tl.invalidateCache();
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                HashMap<Range, ArrayList<String>> splitsToAdd = null;
                if (!autoAdjust) {
                    splitsToAdd = new HashMap<Range, ArrayList<String>>();
                }
                HashMap<String, String> hostNameCache = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
                    String ip = ((String)entry.getKey()).split(":", 2)[0];
                    String location = (String)hostNameCache.get(ip);
                    if (location == null) {
                        InetAddress inetAddress = InetAddress.getByName(ip);
                        location = inetAddress.getCanonicalHostName();
                        hostNameCache.put(ip, location);
                    }
                    for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                        Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                        if (batchScan) {
                            ArrayList<Range> clippedRanges = new ArrayList<Range>();
                            for (Range r : (List)extentRanges.getValue()) {
                                clippedRanges.add(ke.clip(r));
                            }
                            BatchInputSplit split = new BatchInputSplit(tableName, tableId, clippedRanges, new String[]{location});
                            SplitUtils.updateSplit(split, tableConfig);
                            splits.add(split);
                            continue;
                        }
                        for (Range r : (List)extentRanges.getValue()) {
                            if (autoAdjust) {
                                RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonicalID(), ke.clip(r), new String[]{location});
                                SplitUtils.updateSplit(split, tableConfig);
                                split.setOffline(tableConfig.isOfflineScan());
                                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                                splits.add(split);
                                continue;
                            }
                            ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                            if (locations == null) {
                                locations = new ArrayList<String>(1);
                            }
                            locations.add(location);
                            splitsToAdd.put(r, locations);
                        }
                    }
                }
                if (autoAdjust) continue;
                for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                    RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonicalID(), (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                    SplitUtils.updateSplit(split, tableConfig);
                    split.setOffline(tableConfig.isOfflineScan());
                    split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                    split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                    splits.add(split);
                }
            }
        }
        return splits;
    }

    private static AccumuloClient createClient(JobContext context, Class<?> callingClass) {
        return InputConfigurator.createClient(callingClass, context.getConfiguration());
    }
}

