/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoopImpl.mapred;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.clientImpl.OfflineScanner;
import org.apache.accumulo.core.clientImpl.ScannerImpl;
import org.apache.accumulo.core.clientImpl.Table;
import org.apache.accumulo.core.clientImpl.Tables;
import org.apache.accumulo.core.clientImpl.TabletLocator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.hadoopImpl.mapred.BatchInputSplit;
import org.apache.accumulo.hadoopImpl.mapred.RangeInputSplit;
import org.apache.accumulo.hadoopImpl.mapreduce.InputTableConfig;
import org.apache.accumulo.hadoopImpl.mapreduce.SplitUtils;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.InputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AccumuloRecordReader<K, V>
implements RecordReader<K, V> {
    private final Class<?> CLASS;
    private static final Logger log = LoggerFactory.getLogger(AccumuloRecordReader.class);
    protected long numKeysRead;
    protected AccumuloClient client;
    protected Iterator<Map.Entry<Key, Value>> scannerIterator;
    protected RangeInputSplit split;
    private org.apache.accumulo.hadoopImpl.mapreduce.RangeInputSplit baseSplit;
    protected ScannerBase scannerBase;
    protected Key currentKey = null;

    public AccumuloRecordReader(Class<?> callingClass) {
        this.CLASS = callingClass;
    }

    private List<IteratorSetting> jobIterators(JobConf job) {
        return InputConfigurator.getIterators(this.CLASS, (Configuration)job);
    }

    private void setupIterators(JobConf job, ScannerBase scanner, org.apache.accumulo.hadoopImpl.mapreduce.RangeInputSplit split) {
        List<IteratorSetting> iterators = null;
        if (split == null) {
            iterators = this.jobIterators(job);
        } else {
            iterators = split.getIterators();
            if (iterators == null) {
                iterators = this.jobIterators(job);
            }
        }
        for (IteratorSetting iterator : iterators) {
            scanner.addScanIterator(iterator);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(InputSplit inSplit, JobConf job) throws IOException {
        void var10_17;
        Map<String, String> map;
        this.baseSplit = (org.apache.accumulo.hadoopImpl.mapreduce.RangeInputSplit)inSplit;
        log.debug("Initializing input split: " + (Object)((Object)this.baseSplit));
        this.client = AccumuloRecordReader.createClient(job, this.CLASS);
        ClientContext context = (ClientContext)this.client;
        Authorizations authorizations = InputConfigurator.getScanAuthorizations(this.CLASS, (Configuration)job);
        String classLoaderContext = InputConfigurator.getClassLoaderContext(this.CLASS, (Configuration)job);
        String table = this.baseSplit.getTableName();
        InputTableConfig tableConfig = InputConfigurator.getInputTableConfig(this.CLASS, (Configuration)job, this.baseSplit.getTableName());
        log.debug("Created client with user: " + context.whoami());
        log.debug("Creating scanner for table: " + table);
        log.debug("Authorizations are: " + authorizations);
        if (this.baseSplit instanceof BatchInputSplit) {
            BatchScanner scanner;
            BatchInputSplit multiRangeSplit = (BatchInputSplit)this.baseSplit;
            try {
                int n = 1;
                scanner = context.createBatchScanner(this.baseSplit.getTableName(), authorizations, n);
                this.setupIterators(job, (ScannerBase)scanner, this.baseSplit);
                if (classLoaderContext != null) {
                    scanner.setClassLoaderContext(classLoaderContext);
                }
            }
            catch (Exception exception) {
                throw new IOException(exception);
            }
            scanner.setRanges(multiRangeSplit.getRanges());
            this.scannerBase = scanner;
        } else if (this.baseSplit instanceof RangeInputSplit) {
            Object scanner;
            Boolean bl;
            Object isIsolated;
            this.split = (RangeInputSplit)this.baseSplit;
            Boolean isOffline = this.baseSplit.isOffline();
            if (isOffline == null) {
                isOffline = tableConfig.isOfflineScan();
            }
            if ((isIsolated = this.baseSplit.isIsolatedScan()) == null) {
                isIsolated = tableConfig.shouldUseIsolatedScanners();
            }
            if ((bl = this.baseSplit.usesLocalIterators()) == null) {
                Boolean bl2 = tableConfig.shouldUseLocalIterators();
            }
            try {
                void var10_13;
                scanner = isOffline != false ? new OfflineScanner(context, Table.ID.of((String)this.baseSplit.getTableId()), authorizations) : new ScannerImpl(context, Table.ID.of((String)this.baseSplit.getTableId()), authorizations);
                if (((Boolean)isIsolated).booleanValue()) {
                    log.info("Creating isolated scanner");
                    scanner = new IsolatedScanner((Scanner)scanner);
                }
                if (var10_13.booleanValue()) {
                    log.info("Using local iterators");
                    scanner = new ClientSideIteratorScanner((Scanner)scanner);
                }
                this.setupIterators(job, (ScannerBase)scanner, this.baseSplit);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            scanner.setRange(this.baseSplit.getRange());
            this.scannerBase = scanner;
        } else {
            throw new IllegalArgumentException("Can not initialize from " + ((Object)((Object)this.baseSplit)).getClass());
        }
        Collection<IteratorSetting.Column> columns = this.baseSplit.getFetchedColumns();
        if (columns == null) {
            columns = tableConfig.getFetchedColumns();
        }
        for (Pair pair : columns) {
            if (pair.getSecond() != null) {
                log.debug("Fetching column " + pair.getFirst() + ":" + pair.getSecond());
                this.scannerBase.fetchColumn((Text)pair.getFirst(), (Text)pair.getSecond());
                continue;
            }
            log.debug("Fetching column family " + pair.getFirst());
            this.scannerBase.fetchColumnFamily((Text)pair.getFirst());
        }
        SamplerConfiguration samplerConfig = this.baseSplit.getSamplerConfiguration();
        if (samplerConfig == null) {
            samplerConfig = tableConfig.getSamplerConfiguration();
        }
        if (samplerConfig != null) {
            this.scannerBase.setSamplerConfiguration(samplerConfig);
        }
        if ((map = this.baseSplit.getExecutionHints()) == null || map.size() == 0) {
            Map<String, String> map2 = tableConfig.getExecutionHints();
        }
        if (var10_17 != null) {
            this.scannerBase.setExecutionHints((Map)var10_17);
        }
        this.scannerIterator = this.scannerBase.iterator();
        this.numKeysRead = 0L;
    }

    public void close() {
        if (this.scannerBase != null) {
            this.scannerBase.close();
        }
        if (this.client != null) {
            this.client.close();
        }
    }

    public long getPos() {
        return this.numKeysRead;
    }

    public float getProgress() {
        if (this.numKeysRead > 0L && this.currentKey == null) {
            return 1.0f;
        }
        return this.baseSplit.getProgress(this.currentKey);
    }

    private static Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobConf job, Table.ID tableId, List<Range> ranges, Class<?> callingClass) throws TableNotFoundException, AccumuloException {
        try (AccumuloClient client = AccumuloRecordReader.createClient(job, callingClass);){
            Map<String, Map<KeyExtent, List<Range>>> map = InputConfigurator.binOffline(tableId, ranges, (ClientContext)client);
            return map;
        }
    }

    public static InputSplit[] getSplits(JobConf job, Class<?> callingClass) throws IOException {
        AccumuloRecordReader.validateOptions(job, callingClass);
        SecureRandom random = new SecureRandom();
        LinkedList<org.apache.accumulo.hadoopImpl.mapreduce.RangeInputSplit> splits = new LinkedList<org.apache.accumulo.hadoopImpl.mapreduce.RangeInputSplit>();
        Map<String, InputTableConfig> tableConfigs = InputConfigurator.getInputTableConfigs(callingClass, (Configuration)job);
        try (AccumuloClient client = AccumuloRecordReader.createClient(job, callingClass);){
            for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
                ArrayList<Range> ranges;
                boolean supportBatchScan;
                Table.ID tableId;
                String tableName = tableConfigEntry.getKey();
                InputTableConfig tableConfig = tableConfigEntry.getValue();
                ClientContext context = (ClientContext)client;
                try {
                    tableId = Tables.getTableId((ClientContext)context, (String)tableName);
                }
                catch (TableNotFoundException e) {
                    throw new IOException(e);
                }
                boolean batchScan = InputConfigurator.isBatchScan(callingClass, (Configuration)job);
                boolean bl = supportBatchScan = !tableConfig.isOfflineScan() && !tableConfig.shouldUseIsolatedScanners() && !tableConfig.shouldUseLocalIterators();
                if (batchScan && !supportBatchScan) {
                    throw new IllegalArgumentException("BatchScanner optimization not available for offline scan, isolated, or local iterators");
                }
                boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
                if (batchScan && !autoAdjust) {
                    throw new IllegalArgumentException("AutoAdjustRanges must be enabled when using BatchScanner optimization");
                }
                ArrayList<Range> arrayList = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
                if (ranges.isEmpty()) {
                    ranges = new ArrayList<Range>(1);
                    ranges.add(new Range());
                }
                Map<Object, Object> binnedRanges = new HashMap();
                try {
                    if (tableConfig.isOfflineScan()) {
                        binnedRanges = AccumuloRecordReader.binOfflineTable(job, tableId, ranges, callingClass);
                        while (binnedRanges == null) {
                            UtilWaitThread.sleepUninterruptibly((long)(100 + random.nextInt(100)), (TimeUnit)TimeUnit.MILLISECONDS);
                            binnedRanges = AccumuloRecordReader.binOfflineTable(job, tableId, ranges, callingClass);
                        }
                    } else {
                        TabletLocator tl = InputConfigurator.getTabletLocator(callingClass, (Configuration)job, tableId);
                        tl.invalidateCache();
                        while (!tl.binRanges(context, ranges, binnedRanges).isEmpty()) {
                            String tableIdStr = tableId.canonicalID();
                            if (!Tables.exists((ClientContext)context, (Table.ID)tableId)) {
                                throw new TableDeletedException(tableIdStr);
                            }
                            if (Tables.getTableState((ClientContext)context, (Table.ID)tableId) == TableState.OFFLINE) {
                                throw new TableOfflineException(Tables.getTableOfflineMsg((ClientContext)context, (Table.ID)tableId));
                            }
                            binnedRanges.clear();
                            log.warn("Unable to locate bins for specified ranges. Retrying.");
                            UtilWaitThread.sleepUninterruptibly((long)(100 + random.nextInt(100)), (TimeUnit)TimeUnit.MILLISECONDS);
                            tl.invalidateCache();
                        }
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                HashMap<Range, ArrayList<String>> splitsToAdd = null;
                if (!autoAdjust) {
                    splitsToAdd = new HashMap<Range, ArrayList<String>>();
                }
                HashMap<String, String> hostNameCache = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
                    String ip = ((String)entry.getKey()).split(":", 2)[0];
                    String location = (String)hostNameCache.get(ip);
                    if (location == null) {
                        InetAddress inetAddress = InetAddress.getByName(ip);
                        location = inetAddress.getCanonicalHostName();
                        hostNameCache.put(ip, location);
                    }
                    for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                        Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                        if (batchScan) {
                            ArrayList<Range> clippedRanges = new ArrayList<Range>();
                            for (Range r : (List)extentRanges.getValue()) {
                                clippedRanges.add(ke.clip(r));
                            }
                            BatchInputSplit split = new BatchInputSplit(tableName, tableId, clippedRanges, new String[]{location});
                            SplitUtils.updateSplit(split, tableConfig);
                            splits.add(split);
                            continue;
                        }
                        for (Range r : (List)extentRanges.getValue()) {
                            if (autoAdjust) {
                                RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonicalID(), ke.clip(r), new String[]{location});
                                SplitUtils.updateSplit(split, tableConfig);
                                split.setOffline(tableConfig.isOfflineScan());
                                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                                splits.add(split);
                                continue;
                            }
                            ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                            if (locations == null) {
                                locations = new ArrayList<String>(1);
                            }
                            locations.add(location);
                            splitsToAdd.put(r, locations);
                        }
                    }
                }
                if (autoAdjust) continue;
                for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                    RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonicalID(), (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                    SplitUtils.updateSplit(split, tableConfig);
                    split.setOffline(tableConfig.isOfflineScan());
                    split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                    split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                    splits.add(split);
                }
            }
        }
        return splits.toArray(new InputSplit[splits.size()]);
    }

    private static void validateOptions(JobConf job, Class<?> callingClass) throws IOException {
        try (AccumuloClient client = InputConfigurator.createClient(callingClass, (Configuration)job);){
            InputConfigurator.validatePermissions(callingClass, (Configuration)job, client);
        }
    }

    private static AccumuloClient createClient(JobConf job, Class<?> callingClass) {
        return InputConfigurator.createClient(callingClass, (Configuration)job);
    }
}

