/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.hadoop.mapred;

import java.io.IOException;
import java.util.Properties;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.hadoop.mapreduce.OutputFormatBuilder;
import org.apache.accumulo.hadoopImpl.mapred.AccumuloRecordWriter;
import org.apache.accumulo.hadoopImpl.mapreduce.OutputFormatBuilderImpl;
import org.apache.accumulo.hadoopImpl.mapreduce.lib.OutputConfigurator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.util.Progressable;

public class AccumuloOutputFormat
implements OutputFormat<Text, Mutation> {
    private static final Class<AccumuloOutputFormat> CLASS = AccumuloOutputFormat.class;

    public void checkOutputSpecs(FileSystem ignored, JobConf job) throws IOException {
        Properties clientProps = OutputConfigurator.getClientProperties(CLASS, (Configuration)job);
        AuthenticationToken token = ClientProperty.getAuthenticationToken((Properties)clientProps);
        try (AccumuloClient c = (AccumuloClient)Accumulo.newClient().from(clientProps).build();){
            if (!c.securityOperations().authenticateUser(c.whoami(), token)) {
                throw new IOException("Unable to authenticate user");
            }
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IOException(e);
        }
    }

    public RecordWriter<Text, Mutation> getRecordWriter(FileSystem ignored, JobConf job, String name, Progressable progress) throws IOException {
        try {
            return new AccumuloRecordWriter(job);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public static OutputFormatBuilder.ClientParams<JobConf> configure() {
        return new OutputFormatBuilderImpl<JobConf>(CLASS);
    }
}

