/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterators;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.log.WalStateManager;
import org.apache.accumulo.server.master.LiveTServerSet;
import org.apache.accumulo.server.master.state.MetaDataStateStore;
import org.apache.accumulo.server.master.state.RootTabletStateStore;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.server.master.state.TabletState;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectWriteAheadLogs {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectWriteAheadLogs.class);
    private final AccumuloServerContext context;
    private final VolumeManager fs;
    private final boolean useTrash;
    private final LiveTServerSet liveServers;
    private final WalStateManager walMarker;
    private final Iterable<TabletLocationState> store;

    GarbageCollectWriteAheadLogs(final AccumuloServerContext context, VolumeManager fs, boolean useTrash) throws IOException {
        this.context = context;
        this.fs = fs;
        this.useTrash = useTrash;
        this.liveServers = new LiveTServerSet((ClientContext)context, new LiveTServerSet.Listener(){

            public void update(LiveTServerSet current, Set<TServerInstance> deleted, Set<TServerInstance> added) {
                log.debug("New tablet servers noticed: " + added);
                log.debug("Tablet servers removed: " + deleted);
            }
        });
        this.liveServers.startListeningForTabletServerChanges();
        this.walMarker = new WalStateManager(context.getInstance(), ZooReaderWriter.getInstance());
        this.store = new Iterable<TabletLocationState>(){

            @Override
            public Iterator<TabletLocationState> iterator() {
                return Iterators.concat((Iterator)new RootTabletStateStore(context).iterator(), (Iterator)new MetaDataStateStore(context).iterator());
            }
        };
    }

    @VisibleForTesting
    GarbageCollectWriteAheadLogs(AccumuloServerContext context, VolumeManager fs, boolean useTrash, LiveTServerSet liveTServerSet, WalStateManager walMarker, Iterable<TabletLocationState> store) throws IOException {
        this.context = context;
        this.fs = fs;
        this.useTrash = useTrash;
        this.liveServers = liveTServerSet;
        this.walMarker = walMarker;
        this.store = store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collect(GCStatus status) {
        Span span = Trace.start((String)"getCandidates");
        try {
            Map<UUID, TServerInstance> uuidToTServer;
            status.currentLog.started = System.currentTimeMillis();
            HashMap<TServerInstance, Set<UUID>> logsByServer = new HashMap<TServerInstance, Set<UUID>>();
            HashMap<UUID, Pair<WalStateManager.WalState, Path>> logsState = new HashMap<UUID, Pair<WalStateManager.WalState, Path>>();
            long count = this.getCurrent(logsByServer, logsState);
            long fileScanStop = System.currentTimeMillis();
            log.info(String.format("Fetched %d files for %d servers in %.2f seconds", count, logsByServer.size(), (double)(fileScanStop - status.currentLog.started) / 1000.0));
            status.currentLog.candidates = count;
            span.stop();
            Set currentServers = this.liveServers.getCurrentServers();
            span = Trace.start((String)"removeEntriesInUse");
            try {
                uuidToTServer = this.removeEntriesInUse(logsByServer, currentServers, logsState);
                count = uuidToTServer.size();
            }
            catch (Exception ex) {
                log.error("Unable to scan metadata table", (Throwable)ex);
                return;
            }
            long logEntryScanStop = System.currentTimeMillis();
            log.info(String.format("%d log entries scanned in %.2f seconds", count, (double)(logEntryScanStop - fileScanStop) / 1000.0));
            span = Trace.start((String)"removeReplicationEntries");
            try {
                count = this.removeReplicationEntries(uuidToTServer);
            }
            catch (Exception ex) {
                log.error("Unable to scan replication table", (Throwable)ex);
                return;
            }
            finally {
                span.stop();
            }
            long replicationEntryScanStop = System.currentTimeMillis();
            log.info(String.format("%d replication entries scanned in %.2f seconds", count, (double)(replicationEntryScanStop - logEntryScanStop) / 1000.0));
            span = Trace.start((String)"removeFiles");
            logsState.keySet().retainAll(uuidToTServer.keySet());
            count = this.removeFiles(logsState.values(), status);
            long removeStop = System.currentTimeMillis();
            log.info(String.format("%d total logs removed from %d servers in %.2f seconds", count, logsByServer.size(), (double)(removeStop - logEntryScanStop) / 1000.0));
            span.stop();
            span = Trace.start((String)"removeMarkers");
            count = this.removeTabletServerMarkers(uuidToTServer, logsByServer, currentServers);
            long removeMarkersStop = System.currentTimeMillis();
            log.info(String.format("%d markers removed in %.2f seconds", count, (double)(removeMarkersStop - removeStop) / 1000.0));
            span.stop();
            status.currentLog.finished = removeStop;
            status.lastLog = status.currentLog;
            status.currentLog = new GcCycleStats();
            return;
            finally {
                span.stop();
            }
        }
        catch (Exception e) {
            log.error("exception occured while garbage collecting write ahead logs", (Throwable)e);
            return;
        }
        finally {
            span.stop();
        }
    }

    private long removeTabletServerMarkers(Map<UUID, TServerInstance> uidMap, Map<TServerInstance, Set<UUID>> candidates, Set<TServerInstance> liveServers) {
        long result = 0L;
        try {
            for (Map.Entry<UUID, TServerInstance> entry : uidMap.entrySet()) {
                this.walMarker.removeWalMarker(entry.getValue(), entry.getKey());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        for (Map.Entry<UUID, Object> entry : candidates.entrySet()) {
            if (liveServers.contains(entry.getKey())) continue;
            log.info("Removing znode for " + entry.getKey());
            try {
                this.walMarker.forget((TServerInstance)entry.getKey());
            }
            catch (WalStateManager.WalMarkerException ex) {
                log.info("Error removing znode for " + entry.getKey() + " " + ex.toString());
            }
        }
        return result;
    }

    private long removeFiles(Collection<Pair<WalStateManager.WalState, Path>> collection, GCStatus status) {
        for (Pair<WalStateManager.WalState, Path> stateFile : collection) {
            Path path = (Path)stateFile.getSecond();
            log.debug("Removing " + stateFile.getFirst() + " WAL " + path);
            try {
                if (!this.useTrash || !this.fs.moveToTrash(path)) {
                    this.fs.deleteRecursively(path);
                }
                ++status.currentLog.deleted;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException ex) {
                log.error("Unable to delete wal " + path + ": " + ex);
            }
        }
        return status.currentLog.deleted;
    }

    private UUID path2uuid(Path path) {
        return UUID.fromString(path.getName());
    }

    private Map<UUID, TServerInstance> removeEntriesInUse(Map<TServerInstance, Set<UUID>> candidates, Set<TServerInstance> liveServers, Map<UUID, Pair<WalStateManager.WalState, Path>> logsState) throws IOException, KeeperException, InterruptedException {
        HashMap<UUID, TServerInstance> result = new HashMap<UUID, TServerInstance>();
        for (Map.Entry<TServerInstance, Set<UUID>> entry : candidates.entrySet()) {
            for (UUID id : entry.getValue()) {
                result.put(id, entry.getKey());
            }
        }
        for (TabletLocationState state : this.store) {
            Set<UUID> idsToIgnore;
            if (state.getState(liveServers) == TabletState.ASSIGNED_TO_DEAD_SERVER && (idsToIgnore = candidates.remove(state.current)) != null) {
                for (UUID id : idsToIgnore) {
                    result.remove(id);
                }
            }
            for (Collection wals : state.walogs) {
                for (String wal : wals) {
                    UUID walUUID = this.path2uuid(new Path(wal));
                    TServerInstance dead = (TServerInstance)result.get(walUUID);
                    Set<UUID> idsToIgnore2 = candidates.remove(dead);
                    if (idsToIgnore2 == null) continue;
                    for (UUID id : idsToIgnore2) {
                        result.remove(id);
                    }
                }
            }
        }
        for (TServerInstance liveServer : liveServers) {
            Set<UUID> idsForServer = candidates.get(liveServer);
            if (idsForServer == null) continue;
            for (UUID id : idsForServer) {
                Pair<WalStateManager.WalState, Path> stateFile = logsState.get(id);
                if (stateFile.getFirst() == WalStateManager.WalState.UNREFERENCED) continue;
                result.remove(id);
            }
        }
        return result;
    }

    protected int removeReplicationEntries(Map<UUID, TServerInstance> candidates) throws IOException, KeeperException, InterruptedException {
        try {
            Connector conn = this.context.getConnector();
            try {
                Scanner s = ReplicationTable.getScanner((Connector)conn);
                ReplicationSchema.StatusSection.limit((ScannerBase)s);
                for (Map.Entry entry : s) {
                    UUID id = this.path2uuid(new Path(((Key)entry.getKey()).getRow().toString()));
                    candidates.remove(id);
                    log.info("Ignore closed log " + id + " because it is being replicated");
                }
            }
            catch (ReplicationTableOfflineException ex) {
                return candidates.size();
            }
            Scanner scanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
            scanner.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
            scanner.setRange(MetadataSchema.ReplicationSection.getRange());
            for (Map.Entry entry : scanner) {
                Text file = new Text();
                MetadataSchema.ReplicationSection.getFile((Key)((Key)entry.getKey()), (Text)file);
                UUID id = this.path2uuid(new Path(file.toString()));
                candidates.remove(id);
                log.info("Ignore closed log " + id + " because it is being replicated");
            }
            return candidates.size();
        }
        catch (AccumuloException | AccumuloSecurityException | TableNotFoundException e) {
            log.error("Failed to scan metadata table", e);
            throw new IllegalArgumentException(e);
        }
    }

    private long getCurrent(Map<TServerInstance, Set<UUID>> logsByServer, Map<UUID, Pair<WalStateManager.WalState, Path>> logState) throws Exception {
        long result = 0L;
        Map markers = this.walMarker.getAllMarkers();
        for (Map.Entry entry : markers.entrySet()) {
            HashSet<UUID> ids = new HashSet<UUID>(((List)entry.getValue()).size());
            for (UUID id : (List)entry.getValue()) {
                ids.add(id);
                logState.put(id, (Pair<WalStateManager.WalState, Path>)this.walMarker.state((TServerInstance)entry.getKey(), id));
                ++result;
            }
            logsByServer.put((TServerInstance)entry.getKey(), (Set<UUID>)ids);
        }
        return result;
    }
}

