/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.google.common.collect.Iterables;
import com.google.common.net.HostAndPort;
import com.google.protobuf.GeneratedMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTableOfflineException;
import org.apache.accumulo.core.rpc.ThriftUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.trace.Span;
import org.apache.accumulo.core.trace.Trace;
import org.apache.accumulo.core.trace.Tracer;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.AccumuloServerContext;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.replication.StatusUtil;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageCollectWriteAheadLogs {
    private static final Logger log = LoggerFactory.getLogger(GarbageCollectWriteAheadLogs.class);
    private final AccumuloServerContext context;
    private final VolumeManager fs;
    private boolean useTrash;

    GarbageCollectWriteAheadLogs(AccumuloServerContext context, VolumeManager fs, boolean useTrash) throws IOException {
        this.context = context;
        this.fs = fs;
        this.useTrash = useTrash;
    }

    Instance getInstance() {
        return this.context.getInstance();
    }

    VolumeManager getVolumeManager() {
        return this.fs;
    }

    boolean isUsingTrash() {
        return this.useTrash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collect(GCStatus status) {
        Span span = Trace.start((String)"scanServers");
        try {
            Map<String, Path> sortedWALogs = this.getSortedWALogs();
            status.currentLog.started = System.currentTimeMillis();
            HashMap<Path, String> fileToServerMap = new HashMap<Path, String>();
            HashMap<String, Path> nameToFileMap = new HashMap<String, Path>();
            int count = this.scanServers(fileToServerMap, nameToFileMap);
            long fileScanStop = System.currentTimeMillis();
            log.info(String.format("Fetched %d files from %d servers in %.2f seconds", fileToServerMap.size(), count, (double)(fileScanStop - status.currentLog.started) / 1000.0));
            status.currentLog.candidates = fileToServerMap.size();
            span.stop();
            span = Trace.start((String)"removeMetadataEntries");
            try {
                count = this.removeMetadataEntries(nameToFileMap, sortedWALogs, status);
            }
            catch (Exception ex) {
                log.error("Unable to scan metadata table", (Throwable)ex);
                return;
            }
            long logEntryScanStop = System.currentTimeMillis();
            log.info(String.format("%d log entries scanned in %.2f seconds", count, (double)(logEntryScanStop - fileScanStop) / 1000.0));
            span = Trace.start((String)"removeReplicationEntries");
            try {
                count = this.removeReplicationEntries(nameToFileMap, sortedWALogs, status);
            }
            catch (Exception ex) {
                log.error("Unable to scan replication table", (Throwable)ex);
                return;
            }
            finally {
                span.stop();
            }
            long replicationEntryScanStop = System.currentTimeMillis();
            log.info(String.format("%d replication entries scanned in %.2f seconds", count, (double)(replicationEntryScanStop - logEntryScanStop) / 1000.0));
            span = Trace.start((String)"removeFiles");
            Map<String, ArrayList<Path>> serverToFileMap = GarbageCollectWriteAheadLogs.mapServersToFiles(fileToServerMap, nameToFileMap);
            count = this.removeFiles(nameToFileMap, serverToFileMap, sortedWALogs, status);
            long removeStop = System.currentTimeMillis();
            log.info(String.format("%d total logs removed from %d servers in %.2f seconds", count, serverToFileMap.size(), (double)(removeStop - logEntryScanStop) / 1000.0));
            status.currentLog.finished = removeStop;
            status.lastLog = status.currentLog;
            status.currentLog = new GcCycleStats();
            span.stop();
            return;
            finally {
                span.stop();
            }
        }
        catch (Exception e) {
            log.error("exception occured while garbage collecting write ahead logs", (Throwable)e);
            return;
        }
        finally {
            span.stop();
        }
    }

    boolean holdsLock(HostAndPort addr) {
        try {
            String zpath = ZooUtil.getRoot((Instance)this.context.getInstance()) + "/tservers" + "/" + addr.toString();
            List children = ZooReaderWriter.getInstance().getChildren(zpath);
            return children != null && !children.isEmpty();
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (Exception ex) {
            log.debug(ex.toString(), (Throwable)ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFiles(Map<String, Path> nameToFileMap, Map<String, ArrayList<Path>> serverToFileMap, Map<String, Path> sortedWALogs, GCStatus status) {
        for (Map.Entry<String, ArrayList<Path>> entry : serverToFileMap.entrySet()) {
            if (entry.getKey().isEmpty()) {
                for (Path path : entry.getValue()) {
                    log.debug("Removing old-style WAL " + path);
                    try {
                        if (!this.useTrash || !this.fs.moveToTrash(path)) {
                            this.fs.deleteRecursively(path);
                        }
                        ++status.currentLog.deleted;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException ex) {
                        log.error("Unable to delete wal " + path + ": " + ex);
                    }
                }
                continue;
            }
            HostAndPort address = AddressUtil.parseAddress((String)entry.getKey(), (boolean)false);
            if (!this.holdsLock(address)) {
                for (Path path : entry.getValue()) {
                    log.debug("Removing WAL for offline server " + path);
                    try {
                        if (!this.useTrash || !this.fs.moveToTrash(path)) {
                            this.fs.deleteRecursively(path);
                        }
                        ++status.currentLog.deleted;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException ex) {
                        log.error("Unable to delete wal " + path + ": " + ex);
                    }
                }
                continue;
            }
            TabletClientService.Client tserver = null;
            try {
                tserver = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (HostAndPort)address, (ClientContext)this.context);
                tserver.removeLogs(Tracer.traceInfo(), this.context.rpcCreds(), GarbageCollectWriteAheadLogs.paths2strings((List<Path>)entry.getValue()));
                log.debug("deleted " + entry.getValue() + " from " + entry.getKey());
                status.currentLog.deleted += (long)entry.getValue().size();
                if (tserver == null) continue;
            }
            catch (TException e) {
                try {
                    log.warn("Error talking to " + address + ": " + (Object)((Object)e));
                    if (tserver == null) continue;
                }
                catch (Throwable throwable) {
                    if (tserver != null) {
                        ThriftUtil.returnClient(tserver);
                    }
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)tserver);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)tserver);
        }
        for (Path swalog : sortedWALogs.values()) {
            log.debug("Removing sorted WAL " + swalog);
            try {
                if (this.useTrash && this.fs.moveToTrash(swalog)) continue;
                this.fs.deleteRecursively(swalog);
            }
            catch (FileNotFoundException address) {
            }
            catch (IOException ioe) {
                try {
                    if (!this.fs.exists(swalog)) continue;
                    log.error("Unable to delete sorted walog " + swalog + ": " + ioe);
                }
                catch (IOException ex) {
                    log.error("Unable to check for the existence of " + swalog, (Throwable)ex);
                }
            }
        }
        return 0;
    }

    static List<String> paths2strings(List<Path> paths) {
        ArrayList<String> result = new ArrayList<String>(paths.size());
        for (Path path : paths) {
            result.add(path.toString());
        }
        return result;
    }

    static Map<String, ArrayList<Path>> mapServersToFiles(Map<Path, String> fileToServerMap, Map<String, Path> nameToFileMap) {
        HashMap<String, ArrayList<Path>> result = new HashMap<String, ArrayList<Path>>();
        for (Map.Entry<Path, String> fileServer : fileToServerMap.entrySet()) {
            if (!nameToFileMap.containsKey(fileServer.getKey().getName())) continue;
            ArrayList<Path> files = (ArrayList<Path>)result.get(fileServer.getValue());
            if (files == null) {
                files = new ArrayList<Path>();
                result.put(fileServer.getValue(), files);
            }
            files.add(fileServer.getKey());
        }
        return result;
    }

    protected int removeMetadataEntries(Map<String, Path> nameToFileMap, Map<String, Path> sortedWALogs, GCStatus status) throws IOException, KeeperException, InterruptedException {
        int count = 0;
        Iterator iterator = MetadataTableUtil.getLogEntries((ClientContext)this.context);
        while (iterator.hasNext()) {
            for (String entry : ((LogEntry)iterator.next()).logSet) {
                String uuid = entry.substring(entry.lastIndexOf("/") + 1);
                if (!GarbageCollectWriteAheadLogs.isUUID(uuid)) {
                    throw new IllegalArgumentException("Expected uuid, but got " + uuid + " from " + entry);
                }
                Path pathFromNN = nameToFileMap.remove(uuid);
                if (pathFromNN != null) {
                    ++status.currentLog.inUse;
                    sortedWALogs.remove(uuid);
                }
                ++count;
            }
        }
        return count;
    }

    protected int removeReplicationEntries(Map<String, Path> nameToFileMap, Map<String, Path> sortedWALogs, GCStatus status) throws IOException, KeeperException, InterruptedException {
        Connector conn;
        try {
            conn = this.context.getConnector();
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            log.error("Failed to get connector", e);
            throw new IllegalArgumentException(e);
        }
        int count = 0;
        Iterator<Map.Entry<String, Path>> walIter = nameToFileMap.entrySet().iterator();
        while (walIter.hasNext()) {
            Map.Entry<String, Path> wal = walIter.next();
            String fullPath = wal.getValue().toString();
            if (this.neededByReplication(conn, fullPath)) {
                log.debug("Removing WAL from candidate deletion as it is still needed for replication: {}", (Object)fullPath);
                ++status.currentLog.inUse;
                walIter.remove();
                sortedWALogs.remove(wal.getKey());
            } else {
                log.debug("WAL not needed for replication {}", (Object)fullPath);
            }
            ++count;
        }
        return count;
    }

    protected boolean neededByReplication(Connector conn, String wal) {
        log.info("Checking replication table for " + wal);
        Iterable<Map.Entry<Key, Value>> iter = this.getReplicationStatusForFile(conn, wal);
        for (Map.Entry<Key, Value> entry : iter) {
            try {
                Replication.Status status = Replication.Status.parseFrom((byte[])entry.getValue().get());
                log.info("Checking if {} is safe for removal with {}", (Object)wal, (Object)ProtobufUtil.toString((GeneratedMessage)status));
                if (StatusUtil.isSafeForRemoval((Replication.Status)status)) continue;
                return true;
            }
            catch (InvalidProtocolBufferException e) {
                log.error("Could not deserialize Status protobuf for " + entry.getKey(), (Throwable)e);
            }
        }
        return false;
    }

    protected Iterable<Map.Entry<Key, Value>> getReplicationStatusForFile(Connector conn, String wal) {
        Scanner metaScanner;
        try {
            metaScanner = conn.createScanner("accumulo.metadata", Authorizations.EMPTY);
        }
        catch (TableNotFoundException e) {
            throw new RuntimeException(e);
        }
        metaScanner.setRange(Range.exact((CharSequence)(MetadataSchema.ReplicationSection.getRowPrefix() + wal)));
        metaScanner.fetchColumnFamily(MetadataSchema.ReplicationSection.COLF);
        try {
            Scanner replScanner = ReplicationTable.getScanner((Connector)conn);
            ReplicationSchema.StatusSection.limit((ScannerBase)replScanner);
            replScanner.setRange(Range.exact((CharSequence)wal));
            return Iterables.concat((Iterable)metaScanner, (Iterable)replScanner);
        }
        catch (ReplicationTableOfflineException replicationTableOfflineException) {
            return metaScanner;
        }
    }

    private int scanServers(Map<Path, String> fileToServerMap, Map<String, Path> nameToFileMap) throws Exception {
        return this.scanServers(ServerConstants.getWalDirs(), fileToServerMap, nameToFileMap);
    }

    int scanServers(String[] walDirs, Map<Path, String> fileToServerMap, Map<String, Path> nameToFileMap) throws Exception {
        HashSet<String> servers = new HashSet<String>();
        for (String walDir : walDirs) {
            Path walRoot = new Path(walDir);
            FileStatus[] listing = null;
            try {
                listing = this.fs.listStatus(walRoot);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            if (listing == null) continue;
            for (FileStatus status : listing) {
                String server = status.getPath().getName();
                if (status.isDirectory()) {
                    servers.add(server);
                    for (FileStatus file : this.fs.listStatus(new Path(walRoot, server))) {
                        if (GarbageCollectWriteAheadLogs.isUUID(file.getPath().getName())) {
                            fileToServerMap.put(file.getPath(), server);
                            nameToFileMap.put(file.getPath().getName(), file.getPath());
                            continue;
                        }
                        log.info("Ignoring file " + file.getPath() + " because it doesn't look like a uuid");
                    }
                    continue;
                }
                if (GarbageCollectWriteAheadLogs.isUUID(server)) {
                    servers.add("");
                    fileToServerMap.put(status.getPath(), "");
                    nameToFileMap.put(server, status.getPath());
                    continue;
                }
                log.info("Ignoring file " + status.getPath() + " because it doesn't look like a uuid");
            }
        }
        return servers.size();
    }

    private Map<String, Path> getSortedWALogs() throws IOException {
        return this.getSortedWALogs(ServerConstants.getRecoveryDirs());
    }

    Map<String, Path> getSortedWALogs(String[] recoveryDirs) throws IOException {
        HashMap<String, Path> result = new HashMap<String, Path>();
        for (String dir : recoveryDirs) {
            Path recoveryDir = new Path(dir);
            if (!this.fs.exists(recoveryDir)) continue;
            for (FileStatus status : this.fs.listStatus(recoveryDir)) {
                String name = status.getPath().getName();
                if (GarbageCollectWriteAheadLogs.isUUID(name)) {
                    result.put(name, status.getPath());
                    continue;
                }
                log.debug("Ignoring file " + status.getPath() + " because it doesn't look like a uuid");
            }
        }
        return result;
    }

    static boolean isUUID(String name) {
        if (name == null || name.length() != 36) {
            return false;
        }
        try {
            UUID.fromString(name);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

