/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import com.google.common.net.HostAndPort;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.gc.thrift.GCStatus;
import org.apache.accumulo.core.gc.thrift.GcCycleStats;
import org.apache.accumulo.core.security.Credentials;
import org.apache.accumulo.core.tabletserver.log.LogEntry;
import org.apache.accumulo.core.tabletserver.thrift.TabletClientService;
import org.apache.accumulo.core.util.AddressUtil;
import org.apache.accumulo.core.util.ThriftUtil;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.server.ServerConstants;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.accumulo.server.security.SystemCredentials;
import org.apache.accumulo.server.util.MetadataTableUtil;
import org.apache.accumulo.server.zookeeper.ZooReaderWriter;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.accumulo.trace.instrument.Tracer;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Logger;
import org.apache.thrift.TException;
import org.apache.thrift.TServiceClient;
import org.apache.thrift.TServiceClientFactory;
import org.apache.zookeeper.KeeperException;

public class GarbageCollectWriteAheadLogs {
    private static final Logger log = Logger.getLogger(GarbageCollectWriteAheadLogs.class);
    private final Instance instance;
    private final VolumeManager fs;
    private boolean useTrash;

    GarbageCollectWriteAheadLogs(Instance instance, VolumeManager fs, boolean useTrash) throws IOException {
        this.instance = instance;
        this.fs = fs;
        this.useTrash = useTrash;
    }

    Instance getInstance() {
        return this.instance;
    }

    VolumeManager getVolumeManager() {
        return this.fs;
    }

    boolean isUsingTrash() {
        return this.useTrash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collect(GCStatus status) {
        block12: {
            long logEntryScanStop;
            long fileScanStop;
            int count;
            HashMap<String, Path> nameToFileMap;
            HashMap<Path, String> fileToServerMap;
            Map<String, Path> sortedWALogs;
            Span span = Trace.start((String)"scanServers");
            try {
                sortedWALogs = this.getSortedWALogs();
                status.currentLog.started = System.currentTimeMillis();
                fileToServerMap = new HashMap<Path, String>();
                nameToFileMap = new HashMap<String, Path>();
                count = this.scanServers(fileToServerMap, nameToFileMap);
                fileScanStop = System.currentTimeMillis();
                log.info((Object)String.format("Fetched %d files from %d servers in %.2f seconds", fileToServerMap.size(), count, (double)(fileScanStop - status.currentLog.started) / 1000.0));
                status.currentLog.candidates = fileToServerMap.size();
                span.stop();
                span = Trace.start((String)"removeMetadataEntries");
                try {
                    count = this.removeMetadataEntries(nameToFileMap, sortedWALogs, status);
                }
                catch (Exception ex) {
                    log.error((Object)"Unable to scan metadata table", (Throwable)ex);
                    return;
                }
                finally {
                    span.stop();
                }
                logEntryScanStop = System.currentTimeMillis();
            }
            catch (Exception e) {
                log.error((Object)"exception occured while garbage collecting write ahead logs", (Throwable)e);
                break block12;
            }
            finally {
                span.stop();
            }
            log.info((Object)String.format("%d log entries scanned in %.2f seconds", count, (double)(logEntryScanStop - fileScanStop) / 1000.0));
            span = Trace.start((String)"removeFiles");
            Map<String, ArrayList<Path>> serverToFileMap = GarbageCollectWriteAheadLogs.mapServersToFiles(fileToServerMap, nameToFileMap);
            count = this.removeFiles(nameToFileMap, serverToFileMap, sortedWALogs, status);
            long removeStop = System.currentTimeMillis();
            log.info((Object)String.format("%d total logs removed from %d servers in %.2f seconds", count, serverToFileMap.size(), (double)(removeStop - logEntryScanStop) / 1000.0));
            status.currentLog.finished = removeStop;
            status.lastLog = status.currentLog;
            status.currentLog = new GcCycleStats();
            span.stop();
        }
    }

    boolean holdsLock(HostAndPort addr) {
        try {
            String zpath = ZooUtil.getRoot((Instance)this.instance) + "/tservers" + "/" + addr.toString();
            List children = ZooReaderWriter.getInstance().getChildren(zpath);
            return children != null && !children.isEmpty();
        }
        catch (KeeperException.NoNodeException ex) {
            return false;
        }
        catch (Exception ex) {
            log.debug((Object)ex, (Throwable)ex);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeFiles(Map<String, Path> nameToFileMap, Map<String, ArrayList<Path>> serverToFileMap, Map<String, Path> sortedWALogs, GCStatus status) {
        AccumuloConfiguration conf = ServerConfiguration.getSystemConfiguration((Instance)this.instance);
        for (Map.Entry<String, ArrayList<Path>> entry : serverToFileMap.entrySet()) {
            if (entry.getKey().isEmpty()) {
                for (Path path : entry.getValue()) {
                    log.debug((Object)("Removing old-style WAL " + path));
                    try {
                        if (!this.useTrash || !this.fs.moveToTrash(path)) {
                            this.fs.deleteRecursively(path);
                        }
                        ++status.currentLog.deleted;
                    }
                    catch (FileNotFoundException ex) {
                    }
                    catch (IOException ex) {
                        log.error((Object)("Unable to delete wal " + path + ": " + ex));
                    }
                }
                continue;
            }
            HostAndPort address = AddressUtil.parseAddress((String)entry.getKey(), (boolean)false);
            if (!this.holdsLock(address)) {
                for (Path path : entry.getValue()) {
                    log.debug((Object)("Removing WAL for offline server " + path));
                    try {
                        if (!this.useTrash || !this.fs.moveToTrash(path)) {
                            this.fs.deleteRecursively(path);
                        }
                        ++status.currentLog.deleted;
                    }
                    catch (FileNotFoundException ex) {
                    }
                    catch (IOException ex) {
                        log.error((Object)("Unable to delete wal " + path + ": " + ex));
                    }
                }
                continue;
            }
            TabletClientService.Client tserver = null;
            try {
                tserver = (TabletClientService.Client)ThriftUtil.getClient((TServiceClientFactory)new TabletClientService.Client.Factory(), (HostAndPort)address, (AccumuloConfiguration)conf);
                tserver.removeLogs(Tracer.traceInfo(), SystemCredentials.get().toThrift(this.instance), GarbageCollectWriteAheadLogs.paths2strings((List<Path>)entry.getValue()));
                log.debug((Object)("deleted " + entry.getValue() + " from " + entry.getKey()));
                status.currentLog.deleted += (long)entry.getValue().size();
                if (tserver == null) continue;
            }
            catch (TException e) {
                try {
                    log.warn((Object)("Error talking to " + address + ": " + (Object)((Object)e)));
                    if (tserver == null) continue;
                }
                catch (Throwable throwable) {
                    if (tserver != null) {
                        ThriftUtil.returnClient(tserver);
                    }
                    throw throwable;
                }
                ThriftUtil.returnClient((TServiceClient)tserver);
                continue;
            }
            ThriftUtil.returnClient((TServiceClient)tserver);
        }
        for (Path swalog : sortedWALogs.values()) {
            log.debug((Object)("Removing sorted WAL " + swalog));
            try {
                if (this.useTrash && this.fs.moveToTrash(swalog)) continue;
                this.fs.deleteRecursively(swalog);
            }
            catch (FileNotFoundException ex) {
            }
            catch (IOException ioe) {
                try {
                    if (!this.fs.exists(swalog)) continue;
                    log.error((Object)("Unable to delete sorted walog " + swalog + ": " + ioe));
                }
                catch (IOException ex) {
                    log.error((Object)("Unable to check for the existence of " + swalog), (Throwable)ex);
                }
            }
        }
        return 0;
    }

    static List<String> paths2strings(List<Path> paths) {
        ArrayList<String> result = new ArrayList<String>(paths.size());
        for (Path path : paths) {
            result.add(path.toString());
        }
        return result;
    }

    static Map<String, ArrayList<Path>> mapServersToFiles(Map<Path, String> fileToServerMap, Map<String, Path> nameToFileMap) {
        HashMap<String, ArrayList<Path>> result = new HashMap<String, ArrayList<Path>>();
        for (Map.Entry<Path, String> fileServer : fileToServerMap.entrySet()) {
            if (!nameToFileMap.containsKey(fileServer.getKey().getName())) continue;
            ArrayList<Path> files = (ArrayList<Path>)result.get(fileServer.getValue());
            if (files == null) {
                files = new ArrayList<Path>();
                result.put(fileServer.getValue(), files);
            }
            files.add(fileServer.getKey());
        }
        return result;
    }

    private int removeMetadataEntries(Map<String, Path> nameToFileMap, Map<String, Path> sortedWALogs, GCStatus status) throws IOException, KeeperException, InterruptedException {
        int count = 0;
        Iterator iterator = MetadataTableUtil.getLogEntries((Credentials)SystemCredentials.get());
        while (iterator.hasNext()) {
            for (String entry : ((LogEntry)iterator.next()).logSet) {
                String uuid = entry.substring(entry.lastIndexOf("/") + 1);
                if (!GarbageCollectWriteAheadLogs.isUUID(uuid)) {
                    throw new IllegalArgumentException("Expected uuid, but got " + uuid + " from " + entry);
                }
                Path pathFromNN = nameToFileMap.remove(uuid);
                if (pathFromNN != null) {
                    ++status.currentLog.inUse;
                    sortedWALogs.remove(uuid);
                }
                ++count;
            }
        }
        return count;
    }

    private int scanServers(Map<Path, String> fileToServerMap, Map<String, Path> nameToFileMap) throws Exception {
        return this.scanServers(ServerConstants.getWalDirs(), fileToServerMap, nameToFileMap);
    }

    int scanServers(String[] walDirs, Map<Path, String> fileToServerMap, Map<String, Path> nameToFileMap) throws Exception {
        HashSet<String> servers = new HashSet<String>();
        for (String walDir : walDirs) {
            Path walRoot = new Path(walDir);
            FileStatus[] listing = null;
            try {
                listing = this.fs.listStatus(walRoot);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (listing == null) continue;
            for (FileStatus status : listing) {
                String server = status.getPath().getName();
                if (status.isDir()) {
                    servers.add(server);
                    for (FileStatus file : this.fs.listStatus(new Path(walRoot, server))) {
                        if (GarbageCollectWriteAheadLogs.isUUID(file.getPath().getName())) {
                            fileToServerMap.put(file.getPath(), server);
                            nameToFileMap.put(file.getPath().getName(), file.getPath());
                            continue;
                        }
                        log.info((Object)("Ignoring file " + file.getPath() + " because it doesn't look like a uuid"));
                    }
                    continue;
                }
                if (GarbageCollectWriteAheadLogs.isUUID(server)) {
                    servers.add("");
                    fileToServerMap.put(status.getPath(), "");
                    nameToFileMap.put(server, status.getPath());
                    continue;
                }
                log.info((Object)("Ignoring file " + status.getPath() + " because it doesn't look like a uuid"));
            }
        }
        return servers.size();
    }

    private Map<String, Path> getSortedWALogs() throws IOException {
        return this.getSortedWALogs(ServerConstants.getRecoveryDirs());
    }

    Map<String, Path> getSortedWALogs(String[] recoveryDirs) throws IOException {
        HashMap<String, Path> result = new HashMap<String, Path>();
        for (String dir : recoveryDirs) {
            Path recoveryDir = new Path(dir);
            if (!this.fs.exists(recoveryDir)) continue;
            for (FileStatus status : this.fs.listStatus(recoveryDir)) {
                String name = status.getPath().getName();
                if (GarbageCollectWriteAheadLogs.isUUID(name)) {
                    result.put(name, status.getPath());
                    continue;
                }
                log.debug((Object)("Ignoring file " + status.getPath() + " because it doesn't look like a uuid"));
            }
        }
        return result;
    }

    static boolean isUUID(String name) {
        if (name == null || name.length() != 36) {
            return false;
        }
        try {
            UUID.fromString(name);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }
}

