/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.gc;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.KeyExtent;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.metadata.schema.MetadataSchema;
import org.apache.accumulo.gc.GarbageCollectionEnvironment;
import org.apache.accumulo.trace.instrument.Span;
import org.apache.accumulo.trace.instrument.Trace;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Logger;

public class GarbageCollectionAlgorithm {
    private static final Logger log = Logger.getLogger(GarbageCollectionAlgorithm.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String makeRelative(String path, int expectedLen) {
        String relPath = path;
        if (relPath.startsWith("../")) {
            relPath = relPath.substring(3);
        }
        while (relPath.endsWith("/")) {
            relPath = relPath.substring(0, relPath.length() - 1);
        }
        while (relPath.startsWith("/")) {
            relPath = relPath.substring(1);
        }
        String[] tokens = relPath.split("/");
        boolean containsEmpty = false;
        for (String token : tokens) {
            if (!token.equals("")) continue;
            containsEmpty = true;
            break;
        }
        if (containsEmpty) {
            ArrayList<String> tmp = new ArrayList<String>();
            for (String token : tokens) {
                if (token.equals("")) continue;
                tmp.add(token);
            }
            tokens = tmp.toArray(new String[tmp.size()]);
        }
        if (tokens.length > 3 && path.contains(":")) {
            if (tokens[tokens.length - 4].equals("tables")) {
                if (expectedLen == 0) return tokens[tokens.length - 3] + "/" + tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
                if (expectedLen == 3) {
                    return tokens[tokens.length - 3] + "/" + tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
                }
            }
            if (!tokens[tokens.length - 3].equals("tables")) throw new IllegalArgumentException(path);
            if (expectedLen == 0) return tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
            if (expectedLen != 2) throw new IllegalArgumentException(path);
            return tokens[tokens.length - 2] + "/" + tokens[tokens.length - 1];
        }
        if (!(tokens.length != 3 || expectedLen != 0 && expectedLen != 3 || path.contains(":"))) {
            return tokens[0] + "/" + tokens[1] + "/" + tokens[2];
        }
        if (tokens.length != 2) throw new IllegalArgumentException(path);
        if (expectedLen != 0) {
            if (expectedLen != 2) throw new IllegalArgumentException(path);
        }
        if (path.contains(":")) throw new IllegalArgumentException(path);
        return tokens[0] + "/" + tokens[1];
    }

    private SortedMap<String, String> makeRelative(Collection<String> candidates) {
        TreeMap<String, String> ret = new TreeMap<String, String>();
        for (String candidate : candidates) {
            String relPath;
            try {
                relPath = this.makeRelative(candidate, 0);
            }
            catch (IllegalArgumentException iae) {
                log.warn((Object)("Ingoring invalid deletion candidate " + candidate));
                continue;
            }
            ret.put(relPath, candidate);
        }
        return ret;
    }

    private void confirmDeletes(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        boolean checkForBulkProcessingFiles;
        Iterator<String> relativePaths = candidateMap.keySet().iterator();
        for (checkForBulkProcessingFiles = false; !checkForBulkProcessingFiles && relativePaths.hasNext(); checkForBulkProcessingFiles |= relativePaths.next().toLowerCase(Locale.ENGLISH).contains("b-")) {
        }
        if (checkForBulkProcessingFiles) {
            Iterator<String> blipiter = gce.getBlipIterator();
            while (blipiter.hasNext()) {
                String blipPath = blipiter.next();
                blipPath = this.makeRelative(blipPath, 2);
                Iterator<String> tailIter = candidateMap.tailMap(blipPath).keySet().iterator();
                int count = 0;
                while (tailIter.hasNext() && tailIter.next().startsWith(blipPath)) {
                    ++count;
                    tailIter.remove();
                }
                if (count <= 0) continue;
                log.debug((Object)("Folder has bulk processing flag: " + blipPath));
            }
        }
        Iterator<Map.Entry<Key, Value>> iter = gce.getReferenceIterator();
        while (iter.hasNext()) {
            Map.Entry<Key, Value> entry = iter.next();
            Key key = entry.getKey();
            Text cft = key.getColumnFamily();
            if (cft.equals((Object)MetadataSchema.TabletsSection.DataFileColumnFamily.NAME) || cft.equals((Object)MetadataSchema.TabletsSection.ScanFileColumnFamily.NAME)) {
                String dir;
                String cq;
                String reference = cq = key.getColumnQualifier().toString();
                if (cq.startsWith("/")) {
                    String tableID = new String(KeyExtent.tableOfMetadataRow((Text)key.getRow()));
                    reference = "/" + tableID + cq;
                } else if (!cq.contains(":") && !cq.startsWith("../")) {
                    throw new RuntimeException("Bad file reference " + cq);
                }
                reference = this.makeRelative(reference, 3);
                if (candidateMap.remove(reference) != null) {
                    log.debug((Object)("Candidate was still in use: " + reference));
                }
                if (candidateMap.remove(dir = reference.substring(0, reference.lastIndexOf(47))) == null) continue;
                log.debug((Object)("Candidate was still in use: " + reference));
                continue;
            }
            if (MetadataSchema.TabletsSection.ServerColumnFamily.DIRECTORY_COLUMN.hasColumns(key)) {
                String tableID = new String(KeyExtent.tableOfMetadataRow((Text)key.getRow()));
                String dir = entry.getValue().toString();
                if (!dir.contains(":")) {
                    if (!dir.startsWith("/")) {
                        throw new RuntimeException("Bad directory " + dir);
                    }
                    dir = "/" + tableID + dir;
                }
                if (candidateMap.remove(dir = this.makeRelative(dir, 2)) == null) continue;
                log.debug((Object)("Candidate was still in use: " + dir));
                continue;
            }
            throw new RuntimeException("Scanner over metadata table returned unexpected column : " + entry.getKey());
        }
    }

    private void cleanUpDeletedTableDirs(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws IOException {
        HashSet<String> tableIdsWithDeletes = new HashSet<String>();
        for (String delete : candidateMap.keySet()) {
            String[] tokens = delete.split("/");
            if (tokens.length != 2) continue;
            String tableId = delete.split("/")[0];
            tableIdsWithDeletes.add(tableId);
        }
        Set<String> tableIdsInZookeeper = gce.getTableIDs();
        tableIdsWithDeletes.removeAll(tableIdsInZookeeper);
        for (String delTableId : tableIdsWithDeletes) {
            gce.deleteTableDirIfEmpty(delTableId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getCandidates(GarbageCollectionEnvironment gce, String lastCandidate) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        List<String> candidates;
        Span candidatesSpan = Trace.start((String)"getCandidates");
        try {
            candidates = gce.getCandidates(lastCandidate);
        }
        finally {
            candidatesSpan.stop();
        }
        return candidates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmDeletesTrace(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        Span confirmDeletesSpan = Trace.start((String)"confirmDeletes");
        try {
            this.confirmDeletes(gce, candidateMap);
        }
        finally {
            confirmDeletesSpan.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteConfirmed(GarbageCollectionEnvironment gce, SortedMap<String, String> candidateMap) throws IOException, AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Span deleteSpan = Trace.start((String)"deleteFiles");
        try {
            gce.delete(candidateMap);
        }
        finally {
            deleteSpan.stop();
        }
        this.cleanUpDeletedTableDirs(gce, candidateMap);
    }

    public void collect(GarbageCollectionEnvironment gce) throws TableNotFoundException, AccumuloException, AccumuloSecurityException, IOException {
        List<String> candidates;
        String lastCandidate = "";
        while ((candidates = this.getCandidates(gce, lastCandidate)).size() != 0) {
            lastCandidate = candidates.get(candidates.size() - 1);
            long origSize = candidates.size();
            gce.incrementCandidatesStat(origSize);
            SortedMap<String, String> candidateMap = this.makeRelative(candidates);
            this.confirmDeletesTrace(gce, candidateMap);
            gce.incrementInUseStat(origSize - (long)candidateMap.size());
            this.deleteConfirmed(gce, candidateMap);
        }
    }
}

