/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.mapreduce.bulk;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.mapreduce.AccumuloFileOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.partition.RangePartitioner;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class BulkIngestExample
extends Configured
implements Tool {
    public int run(String[] args) {
        if (args.length != 7) {
            System.out.println("ERROR: Wrong number of parameters: " + args.length + " instead of 7.");
            return this.printUsage();
        }
        Configuration conf = this.getConf();
        PrintStream out = null;
        try {
            Job job = new Job(conf, "bulk ingest example");
            job.setJarByClass(((Object)((Object)this)).getClass());
            job.setInputFormatClass(TextInputFormat.class);
            job.setMapperClass(MapClass.class);
            job.setMapOutputKeyClass(Text.class);
            job.setMapOutputValueClass(Text.class);
            job.setReducerClass(ReduceClass.class);
            job.setOutputFormatClass(AccumuloFileOutputFormat.class);
            AccumuloFileOutputFormat.setZooKeeperInstance((JobContext)job, (String)args[0], (String)args[1]);
            ZooKeeperInstance instance = new ZooKeeperInstance(args[0], args[1]);
            String user = args[2];
            byte[] pass = args[3].getBytes();
            String tableName = args[4];
            String inputDir = args[5];
            String workDir = args[6];
            Connector connector = instance.getConnector(user, pass);
            TextInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(inputDir)});
            AccumuloFileOutputFormat.setOutputPath((Job)job, (Path)new Path(workDir + "/files"));
            FileSystem fs = FileSystem.get((Configuration)conf);
            out = new PrintStream(new BufferedOutputStream((OutputStream)fs.create(new Path(workDir + "/splits.txt"))));
            Collection splits = connector.tableOperations().getSplits(tableName, 100);
            for (Text split : splits) {
                out.println(new String(Base64.encodeBase64((byte[])TextUtil.getBytes((Text)split))));
            }
            job.setNumReduceTasks(splits.size() + 1);
            out.close();
            job.setPartitionerClass(RangePartitioner.class);
            RangePartitioner.setSplitFile((JobContext)job, (String)(workDir + "/splits.txt"));
            job.waitForCompletion(true);
            connector.tableOperations().importDirectory(tableName, workDir + "/files", workDir + "/failures", 20, 4, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return 0;
    }

    private int printUsage() {
        System.out.println("accumulo " + ((Object)((Object)this)).getClass().getName() + " <instanceName> <zooKeepers> <username> <password> <table> <input dir> <work dir> ");
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new BulkIngestExample(), (String[])args);
        System.exit(res);
    }

    public static class ReduceClass
    extends Reducer<Text, Text, Key, Value> {
        public void reduce(Text key, Iterable<Text> values, Reducer.Context output) throws IOException, InterruptedException {
            long timestamp = System.currentTimeMillis();
            int index = 0;
            for (Text value : values) {
                Key outputKey = new Key(key, new Text("foo"), new Text("" + index), timestamp);
                ++index;
                Value outputValue = new Value(value.getBytes(), 0, value.getLength());
                output.write((Object)outputKey, (Object)outputValue);
            }
        }
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, Text> {
        private Text outputKey = new Text();
        private Text outputValue = new Text();

        public void map(LongWritable key, Text value, Mapper.Context output) throws IOException, InterruptedException {
            int index = -1;
            for (int i = 0; i < value.getLength(); ++i) {
                if (value.getBytes()[i] != 9) continue;
                index = i;
                break;
            }
            if (index > 0) {
                this.outputKey.set(value.getBytes(), 0, index);
                this.outputValue.set(value.getBytes(), index + 1, value.getLength() - (index + 1));
                output.write((Object)this.outputKey, (Object)this.outputValue);
            }
        }
    }
}

