/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.mapreduce;

import java.io.IOException;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class WordCount
extends Configured
implements Tool {
    private static Options opts;
    private static Option passwordOpt;
    private static Option usernameOpt;
    private static String USAGE;

    public int run(String[] unprocessed_args) throws Exception {
        BasicParser p = new BasicParser();
        CommandLine cl = p.parse(opts, unprocessed_args);
        String[] args = cl.getArgs();
        String username = cl.getOptionValue(usernameOpt.getOpt(), "root");
        String password = cl.getOptionValue(passwordOpt.getOpt(), "secret");
        if (args.length != 4) {
            System.out.println("ERROR: Wrong number of parameters: " + args.length + " instead of 4.");
            return this.printUsage();
        }
        Job job = new Job(this.getConf(), WordCount.class.getName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(TextInputFormat.class);
        TextInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[2])});
        job.setMapperClass(MapClass.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
        AccumuloOutputFormat.setOutputInfo((JobContext)job, (String)username, (byte[])password.getBytes(), (boolean)false, (String)args[3]);
        AccumuloOutputFormat.setZooKeeperInstance((JobContext)job, (String)args[0], (String)args[1]);
        job.waitForCompletion(true);
        return 0;
    }

    private int printUsage() {
        HelpFormatter hf = new HelpFormatter();
        hf.printHelp(USAGE, opts);
        return 0;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new WordCount(), (String[])args);
        System.exit(res);
    }

    static {
        USAGE = "wordCount <instance name> <zoo keepers> <input dir> <output table>";
        usernameOpt = new Option("u", "username", true, "username");
        passwordOpt = new Option("p", "password", true, "password");
        opts = new Options();
        opts.addOption(usernameOpt);
        opts.addOption(passwordOpt);
    }

    public static class MapClass
    extends Mapper<LongWritable, Text, Text, Mutation> {
        public void map(LongWritable key, Text value, Mapper.Context output) throws IOException {
            String[] words;
            for (String word : words = value.toString().split("\\s+")) {
                Mutation mutation = new Mutation(new Text(word));
                mutation.put(new Text("count"), new Text("20080906"), new Value("1".getBytes()));
                try {
                    output.write(null, (Object)mutation);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

