/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.mapreduce;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class TableToFile
extends Configured
implements Tool {
    public int run(String[] args) throws IOException, InterruptedException, ClassNotFoundException {
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName() + "_" + System.currentTimeMillis());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setInputInfo((JobContext)job, (String)args[2], (byte[])args[3].getBytes(), (String)args[4], (Authorizations)new Authorizations());
        AccumuloInputFormat.setZooKeeperInstance((JobContext)job, (String)args[0], (String)args[1]);
        HashSet<Pair> columnsToFetch = new HashSet<Pair>();
        for (String col : args[5].split(",")) {
            int idx = col.indexOf(":");
            Text cf = new Text(idx < 0 ? col : col.substring(0, idx));
            Text cq = idx < 0 ? null : new Text(col.substring(idx + 1));
            columnsToFetch.add(new Pair((Object)cf, (Object)cq));
        }
        AccumuloInputFormat.fetchColumns((JobContext)job, columnsToFetch);
        job.setMapperClass(TTFMapper.class);
        job.setMapOutputKeyClass(NullWritable.class);
        job.setMapOutputValueClass(Text.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(TextOutputFormat.class);
        TextOutputFormat.setOutputPath((Job)job, (Path)new Path(args[6]));
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new TableToFile(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    public static class TTFMapper
    extends Mapper<Key, Value, NullWritable, Text> {
        public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
            final Key r = row;
            final Value v = data;
            Map.Entry<Key, Value> entry = new Map.Entry<Key, Value>(){

                @Override
                public Key getKey() {
                    return r;
                }

                @Override
                public Value getValue() {
                    return v;
                }

                @Override
                public Value setValue(Value value) {
                    return null;
                }
            };
            context.write((Object)NullWritable.get(), (Object)new Text(DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)false)));
            context.setStatus("Outputed Value");
        }
    }
}

