/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.mapreduce;

import java.io.IOException;
import java.util.Collections;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.util.Pair;
import org.apache.commons.codec.binary.Base64;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.log4j.Level;

public class RowHash
extends Configured
implements Tool {
    public int run(String[] args) throws Exception {
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setZooKeeperInstance((JobContext)job, (String)args[0], (String)args[1]);
        AccumuloInputFormat.setInputInfo((JobContext)job, (String)args[2], (byte[])args[3].getBytes(), (String)args[4], (Authorizations)new Authorizations());
        String col = args[5];
        int idx = col.indexOf(":");
        Text cf = new Text(idx < 0 ? col : col.substring(0, idx));
        Text cq = idx < 0 ? null : new Text(col.substring(idx + 1));
        AccumuloInputFormat.fetchColumns((JobContext)job, Collections.singleton(new Pair((Object)cf, (Object)cq)));
        AccumuloInputFormat.setLogLevel((JobContext)job, (Level)Level.TRACE);
        job.setMapperClass(HashDataMapper.class);
        job.setMapOutputKeyClass(Text.class);
        job.setMapOutputValueClass(Mutation.class);
        job.setNumReduceTasks(0);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setZooKeeperInstance((JobContext)job, (String)args[0], (String)args[1]);
        AccumuloOutputFormat.setOutputInfo((JobContext)job, (String)args[2], (byte[])args[3].getBytes(), (boolean)true, (String)args[6]);
        AccumuloOutputFormat.setLogLevel((JobContext)job, (Level)Level.TRACE);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new RowHash(), (String[])args);
        if (res != 0) {
            System.exit(res);
        }
    }

    public static class HashDataMapper
    extends Mapper<Key, Value, Text, Mutation> {
        public void map(Key row, Value data, Mapper.Context context) throws IOException, InterruptedException {
            Mutation m = new Mutation(row.getRow());
            m.put(new Text("cf-HASHTYPE"), new Text("cq-MD5BASE64"), new Value(Base64.encodeBase64((byte[])MD5Hash.digest((String)data.toString()).getDigest())));
            context.write(null, (Object)m);
            context.progress();
        }

        public void setup(Mapper.Context job) {
        }
    }
}

