/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.dirlist;

import java.awt.Component;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.examples.dirlist.QueryUtil;

public class Viewer
extends JFrame
implements TreeSelectionListener,
TreeExpansionListener {
    JTree tree;
    DefaultTreeModel treeModel;
    QueryUtil q;
    String topPath;
    Map<String, DefaultMutableTreeNode> nodeNameMap;
    JTextArea text;

    public Viewer(String instanceName, String zooKeepers, String user, String password, String tableName, Authorizations auths, String path) throws Exception {
        super("File Viewer");
        this.setSize(800, 800);
        this.setDefaultCloseOperation(3);
        this.q = new QueryUtil(instanceName, zooKeepers, user, password, tableName, auths);
        this.topPath = path;
    }

    public void populate(DefaultMutableTreeNode node) throws TableNotFoundException {
        String path = ((NodeInfo)node.getUserObject()).getFullName();
        System.out.println("listing " + path);
        for (Map.Entry<String, Map<String, String>> e : this.q.getDirList(path).entrySet()) {
            System.out.println("got child for " + node.getUserObject() + ": " + e.getKey());
            node.add(new DefaultMutableTreeNode(new NodeInfo(e.getKey(), e.getValue())));
        }
    }

    public void populateChildren(DefaultMutableTreeNode node) throws TableNotFoundException {
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.populate((DefaultMutableTreeNode)children.nextElement());
        }
    }

    public void init() throws TableNotFoundException {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new NodeInfo(this.topPath, this.q.getData(this.topPath)));
        this.populate(root);
        this.populateChildren(root);
        this.treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(this.treeModel);
        this.tree.addTreeExpansionListener(this);
        this.tree.addTreeSelectionListener(this);
        this.text = new JTextArea(Viewer.getText(this.q.getData(this.topPath)));
        JScrollPane treePane = new JScrollPane(this.tree);
        JScrollPane textPane = new JScrollPane(this.text);
        JSplitPane splitPane = new JSplitPane(1, treePane, textPane);
        splitPane.setDividerLocation(0.5);
        this.getContentPane().add((Component)splitPane, "Center");
    }

    public static String getText(DefaultMutableTreeNode node) {
        return Viewer.getText(((NodeInfo)node.getUserObject()).getData());
    }

    public static String getText(Map<String, String> data) {
        StringBuilder sb = new StringBuilder();
        for (String name : data.keySet()) {
            sb.append(name);
            sb.append(" : ");
            sb.append(data.get(name));
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent event) {
        try {
            this.populateChildren((DefaultMutableTreeNode)event.getPath().getLastPathComponent());
        }
        catch (TableNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            System.out.println("removing children of " + ((NodeInfo)child.getUserObject()).getFullName());
            child.removeAllChildren();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath selected = e.getNewLeadSelectionPath();
        if (selected == null) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)selected.getLastPathComponent();
        this.text.setText(Viewer.getText(node));
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 7 && args.length != 6) {
            System.out.println("usage: " + Viewer.class.getSimpleName() + " <instance> <zoo> <user> <pass> <table> <auths> [rootpath]");
            System.exit(1);
        }
        String rootpath = "/";
        if (args.length == 7) {
            rootpath = args[6];
        }
        Viewer v = new Viewer(args[0], args[1], args[2], args[3], args[4], new Authorizations(args[5].split(",")), rootpath);
        v.init();
        v.setVisible(true);
    }

    public static class NodeInfo {
        private String name;
        private Map<String, String> data;
        private boolean lookedUpChildren;

        public NodeInfo(String name, Map<String, String> data) {
            this.name = name;
            this.data = data;
            this.lookedUpChildren = false;
        }

        public String getName() {
            return this.name;
        }

        public String getFullName() {
            String fn = this.data.get("fullname");
            if (fn == null) {
                return this.name;
            }
            return fn;
        }

        public Map<String, String> getData() {
            return this.data;
        }

        public String toString() {
            return this.getName();
        }

        public boolean haveLookedUpChildren() {
            return this.lookedUpChildren;
        }

        public void setLookedUpChildren(boolean lookedUpChildren) {
            this.lookedUpChildren = lookedUpChildren;
        }
    }
}

