/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.dirlist;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.aggregation.Aggregator;
import org.apache.accumulo.core.iterators.aggregation.NumSummation;

public class StringArraySummation
implements Aggregator {
    List<Long> sums = new ArrayList<Long>();

    public void reset() {
        this.sums.clear();
    }

    public void collect(Value value) {
        int i;
        String[] longs = value.toString().split(",");
        for (i = 0; i < this.sums.size() && i < longs.length; ++i) {
            this.sums.set(i, NumSummation.safeAdd((long)this.sums.get(i), (long)Long.parseLong(longs[i])));
        }
        while (i < longs.length) {
            this.sums.add(Long.parseLong(longs[i]));
            ++i;
        }
    }

    public Value aggregate() {
        return new Value(StringArraySummation.longArrayToStringBytes(this.sums.toArray(new Long[this.sums.size()])));
    }

    public static byte[] longArrayToStringBytes(Long[] l) {
        if (l.length == 0) {
            return new byte[0];
        }
        StringBuilder sb = new StringBuilder(Long.toString(l[0]));
        for (int i = 1; i < l.length; ++i) {
            sb.append(",");
            sb.append(Long.toString(l[i]));
        }
        return sb.toString().getBytes();
    }
}

