/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.dirlist;

import java.io.IOException;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.examples.dirlist.QueryUtil;
import org.apache.accumulo.examples.dirlist.StringArraySummation;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class FileCountMR
extends Configured
implements Tool {
    private static final String OUTPUT_VIS = FileCountMR.class.getSimpleName() + ".output.vis";
    private static final Text EMPTY = new Text();

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Configuration)CachedConfiguration.getInstance(), (Tool)new FileCountMR(), (String[])args));
    }

    public int run(String[] args) throws Exception {
        if (args.length < 8) {
            System.out.println("usage: " + FileCountMR.class.getSimpleName() + " <instance> <zoo> <user> <pass> <input table> <output table> <auths> <output visibility>");
            System.exit(1);
        }
        String instance = args[0];
        String zooKeepers = args[1];
        String user = args[2];
        String pass = args[3];
        String inputTable = args[4];
        String outputTable = args[5];
        Authorizations auths = new Authorizations(args[6].split(","));
        String colvis = args[7];
        Job job = new Job(this.getConf(), ((Object)((Object)this)).getClass().getSimpleName());
        job.setJarByClass(((Object)((Object)this)).getClass());
        job.setInputFormatClass(AccumuloInputFormat.class);
        AccumuloInputFormat.setInputInfo((JobContext)job, (String)user, (byte[])pass.getBytes(), (String)inputTable, (Authorizations)auths);
        AccumuloInputFormat.setZooKeeperInstance((JobContext)job, (String)instance, (String)zooKeepers);
        job.setMapperClass(FileCountMapper.class);
        job.setMapOutputKeyClass(Key.class);
        job.setMapOutputValueClass(Value.class);
        job.setReducerClass(FileCountReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Mutation.class);
        job.setOutputFormatClass(AccumuloOutputFormat.class);
        AccumuloOutputFormat.setOutputInfo((JobContext)job, (String)user, (byte[])pass.getBytes(), (boolean)true, (String)outputTable);
        AccumuloOutputFormat.setZooKeeperInstance((JobContext)job, (String)instance, (String)zooKeepers);
        job.setNumReduceTasks(5);
        job.getConfiguration().set(OUTPUT_VIS, colvis);
        job.waitForCompletion(true);
        return job.isSuccessful() ? 0 : 1;
    }

    public static class FileCountReducer
    extends Reducer<Key, Value, Text, Mutation> {
        ColumnVisibility colvis;
        StringArraySummation sas = new StringArraySummation();

        protected void reduce(Key key, Iterable<Value> values, Reducer.Context context) throws IOException, InterruptedException {
            this.sas.reset();
            for (Value v : values) {
                this.sas.collect(v);
            }
            Mutation m = new Mutation(QueryUtil.getRow(key.getRow().toString()));
            m.put(QueryUtil.DIR_COLF, QueryUtil.COUNTS_COLQ, this.colvis, this.sas.aggregate());
            context.write((Object)EMPTY, (Object)m);
        }

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.colvis = new ColumnVisibility(context.getConfiguration().get(OUTPUT_VIS, ""));
        }
    }

    public static class FileCountMapper
    extends Mapper<Key, Value, Key, Value> {
        long dirCount = 0L;
        long fileCount = 0L;
        Text lastRowFound = null;
        String prefix;

        private void incrementCounts(Key k) {
            if (k.getColumnFamily().equals((Object)QueryUtil.DIR_COLF)) {
                ++this.dirCount;
            } else {
                ++this.fileCount;
            }
        }

        private void initVars(Key k) {
            this.lastRowFound = k.getRow();
            this.prefix = this.lastRowFound.toString();
            int slashIndex = this.prefix.lastIndexOf("/");
            if (slashIndex >= 0) {
                this.prefix = this.prefix.substring(0, slashIndex + 1);
            }
            this.dirCount = 0L;
            this.fileCount = 0L;
            this.incrementCounts(k);
        }

        protected void map(Key key, Value value, Mapper.Context context) throws IOException, InterruptedException {
            if (this.lastRowFound == null) {
                this.initVars(key);
                return;
            }
            if (this.lastRowFound.equals((Object)key.getRow())) {
                return;
            }
            if (key.getRow().getLength() > this.prefix.length() && this.prefix.equals(key.getRow().toString().substring(0, this.prefix.length()))) {
                this.lastRowFound = key.getRow();
                this.incrementCounts(key);
                return;
            }
            this.cleanup(context);
            this.initVars(key);
        }

        protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
            int slashIndex;
            if (this.lastRowFound == null) {
                return;
            }
            String lrf = this.lastRowFound.toString().substring(3);
            int parentCount = 0;
            while ((slashIndex = lrf.lastIndexOf("/")) >= 0) {
                Long[] longArray;
                lrf = lrf.substring(0, slashIndex);
                Key key = new Key((CharSequence)lrf);
                if (parentCount == 0) {
                    Long[] longArray2 = new Long[4];
                    longArray2[0] = this.dirCount;
                    longArray2[1] = this.fileCount;
                    longArray2[2] = this.dirCount;
                    longArray = longArray2;
                    longArray2[3] = this.fileCount;
                } else {
                    Long[] longArray3 = new Long[4];
                    longArray3[0] = 0L;
                    longArray3[1] = 0L;
                    longArray3[2] = this.dirCount;
                    longArray = longArray3;
                    longArray3[3] = this.fileCount;
                }
                context.write((Object)key, (Object)new Value(StringArraySummation.longArrayToStringBytes(longArray)));
                ++parentCount;
            }
        }
    }
}

