/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.dirlist;

import java.util.Iterator;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.examples.dirlist.QueryUtil;
import org.apache.hadoop.io.Text;

public class FileCount {
    private int entriesScanned;
    private int inserts;
    private Connector conn;
    private Authorizations auths;
    private ColumnVisibility colvis;
    private String table;

    private int findMaxDepth(Scanner scanner, int min, int max) {
        int mid = min + (max - min) / 2;
        return this.findMaxDepth(scanner, min, mid, max);
    }

    private int findMaxDepth(Scanner scanner, int min, int mid, int max) {
        if (max < min) {
            return -1;
        }
        scanner.setRange(new Range((CharSequence)String.format("%03d", mid), true, (CharSequence)String.format("%03d", mid + 1), false));
        if (scanner.iterator().hasNext()) {
            int ret = this.findMaxDepth(scanner, mid + 1, max);
            if (ret == -1) {
                return mid;
            }
            return ret;
        }
        return this.findMaxDepth(scanner, min, mid - 1);
    }

    private int findMaxDepth(Scanner scanner) {
        int origBatchSize = scanner.getBatchSize();
        scanner.setBatchSize(100);
        int depth = this.findMaxDepth(scanner, 0, 64, 999);
        scanner.setBatchSize(origBatchSize);
        return depth;
    }

    private Map.Entry<Key, Value> findCount(Map.Entry<Key, Value> entry, Iterator<Map.Entry<Key, Value>> iterator, CountValue cv) {
        Key key = entry.getKey();
        Text currentRow = key.getRow();
        if (key.compareColumnQualifier(QueryUtil.COUNTS_COLQ) == 0) {
            cv.set(entry.getValue());
        }
        while (iterator.hasNext()) {
            entry = iterator.next();
            ++this.entriesScanned;
            key = entry.getKey();
            if (key.compareRow(currentRow) != 0) {
                return entry;
            }
            if (key.compareColumnFamily(QueryUtil.DIR_COLF) != 0 || key.compareColumnQualifier(QueryUtil.COUNTS_COLQ) != 0) continue;
            cv.set(entry.getValue());
        }
        return null;
    }

    private Map.Entry<Key, Value> consumeRow(Map.Entry<Key, Value> entry, Iterator<Map.Entry<Key, Value>> iterator) {
        Key key = entry.getKey();
        Text currentRow = key.getRow();
        while (iterator.hasNext()) {
            entry = iterator.next();
            ++this.entriesScanned;
            key = entry.getKey();
            if (key.compareRow(currentRow) == 0) continue;
            return entry;
        }
        return null;
    }

    private String extractDir(Key key) {
        String row = key.getRowData().toString();
        return row.substring(3, row.lastIndexOf(47));
    }

    private Mutation createMutation(int depth, String dir, CountValue countVal) {
        Mutation m = new Mutation((CharSequence)String.format("%03d%s", depth, dir));
        m.put(QueryUtil.DIR_COLF, QueryUtil.COUNTS_COLQ, this.colvis, countVal.toValue());
        return m;
    }

    private void calculateCounts(Scanner scanner, int depth, BatchWriter batchWriter) throws Exception {
        scanner.setRange(new Range((CharSequence)String.format("%03d", depth), true, (CharSequence)String.format("%03d", depth + 1), false));
        CountValue countVal = new CountValue();
        Iterator iterator = scanner.iterator();
        String currentDir = null;
        Map.Entry<Key, Value> entry = null;
        if (iterator.hasNext()) {
            entry = (Map.Entry<Key, Value>)iterator.next();
            ++this.entriesScanned;
        }
        while (entry != null) {
            Key key = (Key)entry.getKey();
            String dir = this.extractDir(key);
            if (currentDir == null) {
                currentDir = dir;
            } else if (!currentDir.equals(dir)) {
                batchWriter.addMutation(this.createMutation(depth - 1, currentDir, countVal));
                ++this.inserts;
                currentDir = dir;
                countVal.clear();
            }
            if (key.compareColumnFamily(QueryUtil.DIR_COLF) == 0) {
                CountValue tmpCount = new CountValue();
                entry = this.findCount(entry, iterator, tmpCount);
                if (tmpCount.dirCount == 0 && tmpCount.fileCount == 0) {
                    Mutation m = new Mutation(key.getRow());
                    m.put(QueryUtil.DIR_COLF, QueryUtil.COUNTS_COLQ, this.colvis, tmpCount.toValue());
                    batchWriter.addMutation(m);
                    ++this.inserts;
                }
                countVal.incrementRecursive(tmpCount);
                countVal.incrementDirs();
                continue;
            }
            entry = this.consumeRow(entry, iterator);
            countVal.incrementFiles();
        }
        if (currentDir != null) {
            batchWriter.addMutation(this.createMutation(depth - 1, currentDir, countVal));
            ++this.inserts;
        }
    }

    FileCount(String instance, String zookeepers, String user, String password, String table, String auths, String colvis) throws Exception {
        ZooKeeperInstance zki = new ZooKeeperInstance(instance, zookeepers);
        this.conn = zki.getConnector(user, (CharSequence)password);
        this.auths = new Authorizations(new String[]{auths});
        this.colvis = new ColumnVisibility(colvis);
        this.table = table;
    }

    public void run() throws Exception {
        this.entriesScanned = 0;
        this.inserts = 0;
        Scanner scanner = this.conn.createScanner(this.table, this.auths);
        BatchWriter bw = this.conn.createBatchWriter(this.table, 10000000L, 60000L, 3);
        long t1 = System.currentTimeMillis();
        int depth = this.findMaxDepth(scanner);
        long t2 = System.currentTimeMillis();
        for (int d = depth; d > 0; --d) {
            this.calculateCounts(scanner, d, bw);
            bw.flush();
        }
        bw.close();
        long t3 = System.currentTimeMillis();
        System.out.printf("Max depth              : %d\n", depth);
        System.out.printf("Time to find max depth : %,d ms\n", t2 - t1);
        System.out.printf("Time to compute counts : %,d ms\n", t3 - t2);
        System.out.printf("Entries scanned        : %,d \n", this.entriesScanned);
        System.out.printf("Counts inserted        : %,d \n", this.inserts);
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 7) {
            System.out.println("usage: " + FileCount.class.getSimpleName() + " <instance> <zookeepers> <user> <pass> <table> <auths> <colvis>");
            System.exit(1);
        }
        FileCount fileCount = new FileCount(args[0], args[1], args[2], args[3], args[4], args[5], args[6]);
        fileCount.run();
    }

    private static class CountValue {
        int dirCount = 0;
        int fileCount = 0;
        int recursiveDirCount = 0;
        int recusiveFileCount = 0;

        private CountValue() {
        }

        void set(Value val) {
            String[] sa = val.toString().split(",");
            this.dirCount = Integer.parseInt(sa[0]);
            this.fileCount = Integer.parseInt(sa[1]);
            this.recursiveDirCount = Integer.parseInt(sa[2]);
            this.recusiveFileCount = Integer.parseInt(sa[3]);
        }

        Value toValue() {
            return new Value((this.dirCount + "," + this.fileCount + "," + this.recursiveDirCount + "," + this.recusiveFileCount).getBytes());
        }

        void incrementFiles() {
            ++this.fileCount;
            ++this.recusiveFileCount;
        }

        void incrementDirs() {
            ++this.dirCount;
            ++this.recursiveDirCount;
        }

        public void clear() {
            this.dirCount = 0;
            this.fileCount = 0;
            this.recursiveDirCount = 0;
            this.recusiveFileCount = 0;
        }

        public void incrementRecursive(CountValue other) {
            this.recursiveDirCount += other.recursiveDirCount;
            this.recusiveFileCount += other.recusiveFileCount;
        }
    }
}

