/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.constraints;

import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.constraints.Constraint;
import org.apache.accumulo.core.data.ColumnUpdate;
import org.apache.accumulo.core.data.Mutation;

public class AlphaNumKeyConstraint
implements Constraint {
    private static final short NON_ALPHA_NUM_ROW = 1;
    private static final short NON_ALPHA_NUM_COLF = 2;
    private static final short NON_ALPHA_NUM_COLQ = 3;

    private boolean isAlphaNum(byte[] bytes) {
        for (byte b : bytes) {
            boolean ok;
            boolean bl = ok = b >= 97 && b <= 122 || b >= 65 && b <= 90 || b >= 48 && b <= 57;
            if (ok) continue;
            return false;
        }
        return true;
    }

    private List<Short> addViolation(List<Short> violations, short violation) {
        if (violations == null) {
            violations = new ArrayList<Short>();
            violations.add(violation);
        } else if (!violations.contains(violation)) {
            violations.add(violation);
        }
        return violations;
    }

    public List<Short> check(Mutation mutation) {
        List<Short> violations = null;
        if (!this.isAlphaNum(mutation.getRow())) {
            violations = this.addViolation(violations, (short)1);
        }
        List updates = mutation.getUpdates();
        for (ColumnUpdate columnUpdate : updates) {
            if (!this.isAlphaNum(columnUpdate.getColumnFamily())) {
                violations = this.addViolation(violations, (short)2);
            }
            if (this.isAlphaNum(columnUpdate.getColumnQualifier())) continue;
            violations = this.addViolation(violations, (short)3);
        }
        return violations;
    }

    public String getViolationDescription(short violationCode) {
        switch (violationCode) {
            case 1: {
                return "Row was not alpha numeric";
            }
            case 2: {
                return "Column family was not alpha numeric";
            }
            case 3: {
                return "Column qualifier was not alpha numeric";
            }
        }
        return null;
    }
}

