/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.client;

import java.util.Map;
import java.util.TreeSet;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.hadoop.io.Text;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ReadWriteExample {
    private static final String DEFAULT_INSTANCE_NAME = "test";
    private static final String DEFAULT_ZOOKEEPERS = "localhost";
    private static final String DEFAULT_AUTHS = "LEVEL1,GROUP1";
    private static final String DEFAULT_TABLE_NAME = "test";
    private Option instanceOpt = new Option("i", "instance", true, "instance name");
    private Option zooKeepersOpt = new Option("z", "zooKeepers", true, "zoo keepers");
    private Option usernameOpt = new Option("u", "user", true, "user name");
    private Option passwordOpt = new Option("p", "password", true, "password");
    private Option scanAuthsOpt = new Option("s", "scanauths", true, "comma-separated scan authorizations");
    private Option tableNameOpt = new Option("t", "table", true, "table name");
    private Option createtableOpt = new Option("C", "createtable", false, "create table before doing anything");
    private Option deletetableOpt = new Option("D", "deletetable", false, "delete table when finished");
    private Option createEntriesOpt = new Option("e", "create", false, "create entries before any deletes");
    private Option deleteEntriesOpt = new Option("d", "delete", false, "delete entries after any creates");
    private Option readEntriesOpt = new Option("r", "read", false, "read entries after any creates/deletes");
    private Option debugOpt = new Option("dbg", "debug", false, "enable debugging");
    private Options opts;
    private CommandLine cl;
    private Connector conn;

    private ReadWriteExample() {
    }

    private void configure(String[] args) throws ParseException, AccumuloException, AccumuloSecurityException {
        this.usernameOpt.setRequired(true);
        this.passwordOpt.setRequired(true);
        this.opts = new Options();
        this.addOptions(this.instanceOpt, this.zooKeepersOpt, this.usernameOpt, this.passwordOpt, this.scanAuthsOpt, this.tableNameOpt, this.createtableOpt, this.deletetableOpt, this.createEntriesOpt, this.deleteEntriesOpt, this.readEntriesOpt, this.debugOpt);
        this.cl = new BasicParser().parse(this.opts, args);
        if (this.cl.getArgs().length != 0) {
            throw new ParseException("unrecognized options " + this.cl.getArgList());
        }
        if (this.hasOpt(this.debugOpt)) {
            Logger.getLogger((String)"org.apache.accumulo.core").setLevel(Level.TRACE);
        }
        ZooKeeperInstance inst = new ZooKeeperInstance(this.getOpt(this.instanceOpt, "test"), this.getOpt(this.zooKeepersOpt, DEFAULT_ZOOKEEPERS));
        this.conn = inst.getConnector(this.getRequiredOpt(this.usernameOpt), this.getRequiredOpt(this.passwordOpt).getBytes());
    }

    private void addOptions(Option ... addOpts) {
        for (Option opt : addOpts) {
            this.opts.addOption(opt);
        }
    }

    private boolean hasOpt(Option opt) {
        return this.cl.hasOption(opt.getOpt());
    }

    private String getRequiredOpt(Option opt) {
        return this.getOpt(opt, null);
    }

    private String getOpt(Option opt, String defaultValue) {
        return this.cl.getOptionValue(opt.getOpt(), defaultValue);
    }

    private void printHelp() {
        HelpFormatter hf = new HelpFormatter();
        this.instanceOpt.setArgName("name");
        this.zooKeepersOpt.setArgName("hosts");
        this.usernameOpt.setArgName("user");
        this.passwordOpt.setArgName("pass");
        this.scanAuthsOpt.setArgName("scanauths");
        this.tableNameOpt.setArgName("name");
        hf.printHelp("accumulo accumulo.examples.client.ReadWriteExample", this.opts, true);
    }

    private void execute() throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException {
        if (this.hasOpt(this.createtableOpt)) {
            TreeSet<Text> partitionKeys = new TreeSet<Text>();
            for (int i = -128; i < 127; ++i) {
                partitionKeys.add(new Text(new byte[]{(byte)i}));
            }
            this.conn.tableOperations().create(this.getOpt(this.tableNameOpt, "test"));
            this.conn.tableOperations().addSplits(this.getOpt(this.tableNameOpt, "test"), partitionKeys);
        }
        if (this.hasOpt(this.createEntriesOpt)) {
            this.createEntries(false);
        }
        if (this.hasOpt(this.deleteEntriesOpt)) {
            this.createEntries(true);
        }
        if (this.hasOpt(this.readEntriesOpt)) {
            Authorizations scanauths = new Authorizations(this.getOpt(this.scanAuthsOpt, DEFAULT_AUTHS).split(","));
            Scanner scanner = this.conn.createScanner(this.getOpt(this.tableNameOpt, "test"), scanauths);
            for (Map.Entry entry : scanner) {
                System.out.println(((Key)entry.getKey()).toString() + " -> " + ((Value)entry.getValue()).toString());
            }
        }
        if (this.hasOpt(this.deletetableOpt)) {
            this.conn.tableOperations().delete(this.getOpt(this.tableNameOpt, "test"));
        }
    }

    private void createEntries(boolean delete) throws AccumuloException, TableNotFoundException, MutationsRejectedException {
        BatchWriter writer = this.conn.createBatchWriter(this.getOpt(this.tableNameOpt, "test"), 10000L, Long.MAX_VALUE, 1);
        ColumnVisibility cv = new ColumnVisibility(DEFAULT_AUTHS.replace(',', '|'));
        Text cf = new Text("datatypes");
        Text cq = new Text("xml");
        byte[] row = new byte[]{104, 101, 108, 108, 111, 0};
        byte[] value = new byte[]{119, 111, 114, 108, 100, 0};
        for (int i = 0; i < 10; ++i) {
            row[row.length - 1] = (byte)i;
            Mutation m = new Mutation(new Text(row));
            if (delete) {
                m.putDelete(cf, cq, cv);
            } else {
                value[value.length - 1] = (byte)i;
                m.put(cf, cq, cv, new Value(value));
            }
            writer.addMutation(m);
        }
        writer.close();
    }

    public static void main(String[] args) throws Exception {
        ReadWriteExample rwe = new ReadWriteExample();
        try {
            rwe.configure(args);
            rwe.execute();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            rwe.printHelp();
            System.exit(1);
        }
    }
}

