/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.partition;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Scanner;
import java.util.TreeSet;
import org.apache.accumulo.core.client.mapreduce.lib.impl.DistributedCacheHelper;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;

public class RangePartitioner
extends Partitioner<Text, Writable>
implements Configurable {
    private static final String PREFIX = RangePartitioner.class.getName();
    private static final String CUTFILE_KEY = PREFIX + ".cutFile";
    private static final String NUM_SUBBINS = PREFIX + ".subBins";
    private Configuration conf;
    private int _numSubBins = 0;
    private Text[] cutPointArray = null;

    public int getPartition(Text key, Writable value, int numPartitions) {
        try {
            return this.findPartition(key, this.getCutPoints(), this.getNumSubBins());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    int findPartition(Text key, Text[] array, int numSubBins) {
        int index = Arrays.binarySearch(array, key);
        int n = index = index < 0 ? (index + 1) * -1 : index;
        if (numSubBins < 2) {
            return index;
        }
        return (key.toString().hashCode() & Integer.MAX_VALUE) % numSubBins + index * numSubBins;
    }

    private synchronized int getNumSubBins() {
        if (this._numSubBins < 1) {
            this._numSubBins = Math.max(1, this.getConf().getInt(NUM_SUBBINS, 1));
        }
        return this._numSubBins;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="path provided by distributed cache framework, not user input")
    private synchronized Text[] getCutPoints() throws IOException {
        if (this.cutPointArray == null) {
            String cutFileName = this.conf.get(CUTFILE_KEY);
            Path[] cf = DistributedCacheHelper.getLocalCacheFiles(this.conf);
            if (cf != null) {
                for (Path path : cf) {
                    if (!path.toUri().getPath().endsWith(cutFileName.substring(cutFileName.lastIndexOf(47)))) continue;
                    TreeSet<Text> cutPoints = new TreeSet<Text>();
                    try (Scanner in = new Scanner(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path.toString()), StandardCharsets.UTF_8)));){
                        while (in.hasNextLine()) {
                            cutPoints.add(new Text(Base64.getDecoder().decode(in.nextLine())));
                        }
                    }
                    this.cutPointArray = cutPoints.toArray(new Text[cutPoints.size()]);
                    break;
                }
            }
            if (this.cutPointArray == null) {
                throw new FileNotFoundException(cutFileName + " not found in distributed cache");
            }
        }
        return this.cutPointArray;
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public static void setSplitFile(Job job, String file) {
        URI uri = new Path(file).toUri();
        DistributedCacheHelper.addCacheFile(uri, job.getConfiguration());
        job.getConfiguration().set(CUTFILE_KEY, uri.getPath());
    }

    public static void setNumSubBins(Job job, int num) {
        job.getConfiguration().setInt(NUM_SUBBINS, num);
    }
}

