/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.impl;

import com.beust.jcommander.Parameter;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientInfo;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.AccumuloOutputFormat;
import org.apache.accumulo.core.client.mapreduce.lib.impl.MapReduceClientOpts;
import org.apache.hadoop.mapreduce.Job;

public class MapReduceClientOnDefaultTable
extends MapReduceClientOpts {
    @Parameter(names={"--table"}, description="table to use")
    public String tableName;

    public MapReduceClientOnDefaultTable(String table) {
        this.tableName = table;
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void setAccumuloConfigs(Job job) throws AccumuloSecurityException {
        super.setAccumuloConfigs(job);
        String tableName = this.getTableName();
        ClientInfo info = this.getClientInfo();
        AccumuloInputFormat.setClientInfo(job, info);
        AccumuloInputFormat.setInputTableName(job, tableName);
        AccumuloInputFormat.setScanAuthorizations(job, this.auths);
        AccumuloOutputFormat.setClientInfo(job, info);
        AccumuloOutputFormat.setCreateTables(job, true);
        AccumuloOutputFormat.setDefaultTableName(job, tableName);
    }
}

