/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.impl;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationCopy;
import org.apache.accumulo.core.conf.DefaultConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.sample.impl.SamplerConfigurationImpl;
import org.apache.hadoop.conf.Configuration;

public class FileOutputConfigurator
extends ConfiguratorBase {
    protected static Boolean isSupportedAccumuloProperty(Property property) {
        switch (property) {
            case TABLE_FILE_COMPRESSION_TYPE: 
            case TABLE_FILE_COMPRESSED_BLOCK_SIZE: 
            case TABLE_FILE_BLOCK_SIZE: 
            case TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX: 
            case TABLE_FILE_REPLICATION: {
                return true;
            }
        }
        return false;
    }

    private static <T> void setAccumuloProperty(Class<?> implementingClass, Configuration conf, Property property, T value) {
        String val;
        if (FileOutputConfigurator.isSupportedAccumuloProperty(property).booleanValue()) {
            val = String.valueOf(value);
            if (!property.getType().isValidFormat(val)) {
                throw new IllegalArgumentException("Value is not appropriate for property type '" + property.getType() + "'");
            }
        } else {
            throw new IllegalArgumentException("Unsupported configuration property " + property.getKey());
        }
        conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + property.getKey(), val);
    }

    public static AccumuloConfiguration getAccumuloConfiguration(Class<?> implementingClass, Configuration conf) {
        String prefix = FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + ".";
        ConfigurationCopy acuConf = new ConfigurationCopy((Iterable)DefaultConfiguration.getInstance());
        for (Map.Entry entry : conf) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            String propString = ((String)entry.getKey()).substring(prefix.length());
            Property prop = Property.getPropertyByKey((String)propString);
            if (prop != null) {
                acuConf.set(prop, (String)entry.getValue());
                continue;
            }
            if (Property.isValidTablePropertyKey((String)propString)) {
                acuConf.set(propString, (String)entry.getValue());
                continue;
            }
            throw new IllegalArgumentException("Unknown accumulo file property " + propString);
        }
        return acuConf;
    }

    public static void setCompressionType(Class<?> implementingClass, Configuration conf, String compressionType) {
        if (compressionType == null || !Arrays.asList("none", "gz", "lzo", "snappy", "zstd").contains(compressionType)) {
            throw new IllegalArgumentException("Compression type must be one of: none, gz, lzo, snappy, zstd");
        }
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSION_TYPE, compressionType);
    }

    public static void setDataBlockSize(Class<?> implementingClass, Configuration conf, long dataBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE, dataBlockSize);
    }

    public static void setFileBlockSize(Class<?> implementingClass, Configuration conf, long fileBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_BLOCK_SIZE, fileBlockSize);
    }

    public static void setIndexBlockSize(Class<?> implementingClass, Configuration conf, long indexBlockSize) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_COMPRESSED_BLOCK_SIZE_INDEX, indexBlockSize);
    }

    public static void setReplication(Class<?> implementingClass, Configuration conf, int replication) {
        FileOutputConfigurator.setAccumuloProperty(implementingClass, conf, Property.TABLE_FILE_REPLICATION, replication);
    }

    public static void setSampler(Class<?> implementingClass, Configuration conf, SamplerConfiguration samplerConfig) {
        Map props = new SamplerConfigurationImpl(samplerConfig).toTablePropertiesMap();
        Set es = props.entrySet();
        for (Map.Entry entry : es) {
            conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static void setSummarizers(Class<?> implementingClass, Configuration conf, SummarizerConfiguration[] sumarizerConfigs) {
        Map props = SummarizerConfiguration.toTableProperties((SummarizerConfiguration[])sumarizerConfigs);
        for (Map.Entry entry : props.entrySet()) {
            conf.set(FileOutputConfigurator.enumToConfKey(implementingClass, Opts.ACCUMULO_PROPERTIES) + "." + (String)entry.getKey(), (String)entry.getValue());
        }
    }

    public static enum Opts {
        ACCUMULO_PROPERTIES;

    }
}

