/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.lib.impl;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ClientInfo;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.ClientConfConverter;
import org.apache.accumulo.core.client.impl.ClientInfoImpl;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.mapreduce.impl.DelegationTokenStub;
import org.apache.accumulo.core.client.mapreduce.lib.impl.DistributedCacheHelper;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.DelegationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.conf.ClientProperty;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.StringUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ConfiguratorBase {
    protected static final Logger log = Logger.getLogger(ConfiguratorBase.class);

    protected static String enumToConfKey(Class<?> implementingClass, Enum<?> e) {
        return implementingClass.getSimpleName() + "." + e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    protected static String enumToConfKey(Enum<?> e) {
        return e.getDeclaringClass().getSimpleName() + "." + StringUtils.camelize((String)e.name().toLowerCase());
    }

    public static ClientInfo updateToken(Credentials credentials, ClientInfo info) {
        ClientInfo result = info;
        if (info.getAuthenticationToken() instanceof KerberosToken) {
            log.info((Object)"Received KerberosToken, attempting to fetch DelegationToken");
            try {
                AccumuloClient client = Accumulo.newClient().usingClientInfo(info).build();
                DelegationToken token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
                result = Accumulo.newClient().usingClientInfo(info).usingToken(info.getPrincipal(), (AuthenticationToken)token).info();
            }
            catch (Exception e) {
                log.warn((Object)"Failed to automatically obtain DelegationToken, Mappers/Reducers will likely fail to communicate with Accumulo", (Throwable)e);
            }
        }
        if (info.getAuthenticationToken() instanceof DelegationTokenImpl) {
            DelegationTokenImpl delegationToken = (DelegationTokenImpl)info.getAuthenticationToken();
            AuthenticationTokenIdentifier identifier = delegationToken.getIdentifier();
            Token hadoopToken = new Token(identifier.getBytes(), delegationToken.getPassword(), identifier.getKind(), delegationToken.getServiceName());
            credentials.addToken(hadoopToken.getService(), hadoopToken);
        }
        return result;
    }

    public static void setClientInfo(Class<?> implementingClass, Configuration conf, ClientInfo info) {
        ConfiguratorBase.setClientProperties(implementingClass, conf, info.getProperties());
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), true);
    }

    public static ClientInfo getClientInfo(Class<?> implementingClass, Configuration conf) {
        Properties props = ConfiguratorBase.getClientProperties(implementingClass, conf);
        return new ClientInfoImpl(props);
    }

    public static void setClientPropertiesFile(Class<?> implementingClass, Configuration conf, String clientPropertiesFile) {
        try {
            DistributedCacheHelper.addCacheFile(new URI(clientPropertiesFile), conf);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Unable to add client properties file \"" + clientPropertiesFile + "\" to distributed cache.");
        }
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS_FILE), clientPropertiesFile);
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), true);
    }

    public static void setClientProperties(Class<?> implementingClass, Configuration conf, Properties props) {
        StringWriter writer = new StringWriter();
        try {
            props.store(writer, "client properties");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        conf.set(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS), writer.toString());
    }

    public static Properties getClientProperties(Class<?> implementingClass, Configuration conf) {
        String propString;
        String clientPropsFile = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS_FILE), "");
        if (!clientPropsFile.isEmpty()) {
            try {
                URI[] uris = DistributedCacheHelper.getCacheFiles(conf);
                Path path = null;
                for (URI u : uris) {
                    if (!u.toString().equals(clientPropsFile)) continue;
                    path = new Path(u);
                }
                FileSystem fs = FileSystem.get((Configuration)conf);
                FSDataInputStream inputStream = fs.open(path);
                StringBuilder sb = new StringBuilder();
                try (Scanner scanner = new Scanner((InputStream)inputStream);){
                    while (scanner.hasNextLine()) {
                        sb.append(scanner.nextLine() + "\n");
                    }
                }
                propString = sb.toString();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to read client properties from distributed cache: " + clientPropsFile);
            }
        }
        propString = conf.get(ConfiguratorBase.enumToConfKey(implementingClass, ClientOpts.CLIENT_PROPS), "");
        Properties props = new Properties();
        if (!propString.isEmpty()) {
            try {
                props.load(new StringReader(propString));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return props;
    }

    public static void setConnectorInfo(Class<?> implementingClass, Configuration conf, String principal, AuthenticationToken token) {
        Preconditions.checkArgument((principal != null ? 1 : 0) != 0, (Object)"principal is null");
        Preconditions.checkArgument((token != null ? 1 : 0) != 0, (Object)"token is null");
        Properties props = ConfiguratorBase.getClientProperties(implementingClass, conf);
        props.setProperty(ClientProperty.AUTH_PRINCIPAL.getKey(), principal);
        ClientProperty.setAuthenticationToken((Properties)props, (AuthenticationToken)token);
        ConfiguratorBase.setClientProperties(implementingClass, conf, props);
        conf.setBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), true);
    }

    public static Boolean isConnectorInfoSet(Class<?> implementingClass, Configuration conf) {
        return conf.getBoolean(ConfiguratorBase.enumToConfKey(implementingClass, ConnectorInfo.IS_CONFIGURED), false);
    }

    public static String getPrincipal(Class<?> implementingClass, Configuration conf) {
        Properties props = ConfiguratorBase.getClientProperties(implementingClass, conf);
        return props.getProperty(ClientProperty.AUTH_PRINCIPAL.getKey());
    }

    public static AuthenticationToken getAuthenticationToken(Class<?> implementingClass, Configuration conf) {
        Properties props = ConfiguratorBase.getClientProperties(implementingClass, conf);
        return ClientProperty.getAuthenticationToken((Properties)props);
    }

    @Deprecated
    public static void setZooKeeperInstance(Class<?> implementingClass, Configuration conf, ClientConfiguration clientConfig) {
        Properties props = ConfiguratorBase.getClientProperties(implementingClass, conf);
        Properties newProps = ClientConfConverter.toProperties((ClientConfiguration)clientConfig);
        for (Object keyObj : newProps.keySet()) {
            String propKey = (String)keyObj;
            String val = newProps.getProperty(propKey);
            props.setProperty(propKey, val);
        }
        ConfiguratorBase.setClientProperties(implementingClass, conf, props);
    }

    @Deprecated
    public static Instance getInstance(Class<?> implementingClass, Configuration conf) {
        return Connector.from((AccumuloClient)ConfiguratorBase.getClient(implementingClass, conf)).getInstance();
    }

    public static AccumuloClient getClient(Class<?> implementingClass, Configuration conf) {
        try {
            return Accumulo.newClient().usingClientInfo(ConfiguratorBase.getClientInfo(implementingClass, conf)).build();
        }
        catch (AccumuloException | AccumuloSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @Deprecated
    public static ClientConfiguration getClientConfiguration(Class<?> implementingClass, Configuration conf) {
        return ClientConfConverter.toClientConf((Properties)ConfiguratorBase.getClientInfo(implementingClass, conf).getProperties());
    }

    public static void setLogLevel(Class<?> implementingClass, Configuration conf, Level level) {
        Preconditions.checkArgument((level != null ? 1 : 0) != 0, (Object)"level is null");
        Logger.getLogger(implementingClass).setLevel(level);
        conf.setInt(ConfiguratorBase.enumToConfKey(implementingClass, GeneralOpts.LOG_LEVEL), level.toInt());
    }

    public static Level getLogLevel(Class<?> implementingClass, Configuration conf) {
        return Level.toLevel((int)conf.getInt(ConfiguratorBase.enumToConfKey(implementingClass, GeneralOpts.LOG_LEVEL), Level.INFO.toInt()));
    }

    public static void setVisibilityCacheSize(Configuration conf, int visibilityCacheSize) {
        conf.setInt(ConfiguratorBase.enumToConfKey(GeneralOpts.VISIBILITY_CACHE_SIZE), visibilityCacheSize);
    }

    public static int getVisibilityCacheSize(Configuration conf) {
        return conf.getInt(ConfiguratorBase.enumToConfKey(GeneralOpts.VISIBILITY_CACHE_SIZE), 1000);
    }

    public static AuthenticationToken unwrapAuthenticationToken(JobConf job, AuthenticationToken token) {
        Objects.requireNonNull(job);
        Objects.requireNonNull(token);
        if (token instanceof DelegationTokenStub) {
            DelegationTokenStub delTokenStub = (DelegationTokenStub)token;
            Token hadoopToken = job.getCredentials().getToken(new Text(delTokenStub.getServiceName()));
            AuthenticationTokenIdentifier identifier = new AuthenticationTokenIdentifier();
            try {
                identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(hadoopToken.getIdentifier())));
                return new DelegationTokenImpl(hadoopToken.getPassword(), identifier);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not construct DelegationToken from JobConf Credentials", e);
            }
        }
        return token;
    }

    public static AuthenticationToken unwrapAuthenticationToken(JobContext job, AuthenticationToken token) {
        Objects.requireNonNull(job);
        Objects.requireNonNull(token);
        if (token instanceof DelegationTokenStub) {
            DelegationTokenStub delTokenStub = (DelegationTokenStub)token;
            Token hadoopToken = job.getCredentials().getToken(new Text(delTokenStub.getServiceName()));
            AuthenticationTokenIdentifier identifier = new AuthenticationTokenIdentifier();
            try {
                identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(hadoopToken.getIdentifier())));
                return new DelegationTokenImpl(hadoopToken.getPassword(), identifier);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not construct DelegationToken from JobConf Credentials", e);
            }
        }
        return token;
    }

    public static enum GeneralOpts {
        LOG_LEVEL,
        VISIBILITY_CACHE_SIZE;

    }

    public static enum ClientOpts {
        CLIENT_PROPS,
        CLIENT_PROPS_FILE;

    }

    public static enum ConnectorInfo {
        IS_CONFIGURED;

    }
}

