/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.impl.SplitUtils;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;

public class BatchInputSplit
extends RangeInputSplit {
    private Collection<Range> ranges;
    private float[] rangeProgress = null;

    public BatchInputSplit() {
        this.ranges = Collections.emptyList();
    }

    public BatchInputSplit(BatchInputSplit split) throws IOException {
        super(split);
        this.setRanges(split.getRanges());
    }

    public BatchInputSplit(String table, Table.ID tableId, Collection<Range> ranges, String[] locations) {
        super(table, tableId.canonicalID(), new Range(), locations);
        this.ranges = ranges;
    }

    @Override
    public float getProgress(Key currentKey) {
        if (null == this.rangeProgress) {
            this.rangeProgress = new float[this.ranges.size()];
        }
        float total = 0.0f;
        if (currentKey == null) {
            for (float progress : this.rangeProgress) {
                total += progress;
            }
        } else {
            int i = 0;
            for (Range range : this.ranges) {
                if (range.contains(currentKey)) {
                    if (range.getStartKey() != null && range.getEndKey() != null) {
                        if (range.getStartKey().compareTo(range.getEndKey(), PartialKey.ROW) != 0) {
                            this.rangeProgress[i] = SplitUtils.getProgress(range.getStartKey().getRowData(), range.getEndKey().getRowData(), currentKey.getRowData());
                        } else if (range.getStartKey().compareTo(range.getEndKey(), PartialKey.ROW_COLFAM) != 0) {
                            this.rangeProgress[i] = SplitUtils.getProgress(range.getStartKey().getColumnFamilyData(), range.getEndKey().getColumnFamilyData(), currentKey.getColumnFamilyData());
                        } else if (range.getStartKey().compareTo(range.getEndKey(), PartialKey.ROW_COLFAM_COLQUAL) != 0) {
                            this.rangeProgress[i] = SplitUtils.getProgress(range.getStartKey().getColumnQualifierData(), range.getEndKey().getColumnQualifierData(), currentKey.getColumnQualifierData());
                        }
                    }
                    total += this.rangeProgress[i];
                }
                ++i;
            }
        }
        return total / (float)this.ranges.size();
    }

    @Override
    public long getLength() throws IOException {
        long sum = 0L;
        for (Range range : this.ranges) {
            sum += SplitUtils.getRangeLength(range);
        }
        return sum;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int numRanges = in.readInt();
        this.ranges = new ArrayList<Range>(numRanges);
        for (int i = 0; i < numRanges; ++i) {
            Range r = new Range();
            r.readFields(in);
            this.ranges.add(r);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.ranges.size());
        for (Range r : this.ranges) {
            r.write(out);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("BatchInputSplit:");
        sb.append(" Ranges: ").append(Arrays.asList(this.ranges));
        sb.append(super.toString());
        return sb.toString();
    }

    public void setRanges(Collection<Range> ranges) {
        this.ranges = ranges;
    }

    public Collection<Range> getRanges() {
        return this.ranges;
    }

    @Override
    public Range getRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRange(Range range) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean isIsolatedScan() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setIsolatedScan(Boolean isolatedScan) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean isOffline() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setOffline(Boolean offline) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Boolean usesLocalIterators() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setUsesLocalIterators(Boolean localIterators) {
        throw new UnsupportedOperationException();
    }
}

