/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapreduce;

import java.io.IOException;
import java.net.InetAddress;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.Accumulo;
import org.apache.accumulo.core.client.AccumuloClient;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchScanner;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.ClientInfo;
import org.apache.accumulo.core.client.ClientSideIteratorScanner;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.IsolatedScanner;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.ScannerBase;
import org.apache.accumulo.core.client.TableDeletedException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.TableOfflineException;
import org.apache.accumulo.core.client.admin.DelegationTokenConfig;
import org.apache.accumulo.core.client.impl.AuthenticationTokenIdentifier;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.DelegationTokenImpl;
import org.apache.accumulo.core.client.impl.OfflineScanner;
import org.apache.accumulo.core.client.impl.ScannerImpl;
import org.apache.accumulo.core.client.impl.Table;
import org.apache.accumulo.core.client.impl.Tables;
import org.apache.accumulo.core.client.impl.TabletLocator;
import org.apache.accumulo.core.client.mapreduce.AccumuloInputFormat;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.RangeInputSplit;
import org.apache.accumulo.core.client.mapreduce.impl.BatchInputSplit;
import org.apache.accumulo.core.client.mapreduce.impl.SplitUtils;
import org.apache.accumulo.core.client.mapreduce.lib.impl.ConfiguratorBase;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.state.tables.TableState;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.core.util.Pair;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.security.token.Token;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public abstract class AbstractInputFormat<K, V>
extends InputFormat<K, V> {
    protected static final Class<?> CLASS = AccumuloInputFormat.class;
    protected static final Logger log = Logger.getLogger(CLASS);

    public static void setClassLoaderContext(Job job, String context) {
        InputConfigurator.setClassLoaderContext(CLASS, job.getConfiguration(), context);
    }

    public static String getClassLoaderContext(JobContext job) {
        return InputConfigurator.getClassLoaderContext(CLASS, job.getConfiguration());
    }

    public static void setClientInfo(Job job, ClientInfo info) {
        ClientInfo inputInfo = InputConfigurator.updateToken(job.getCredentials(), info);
        InputConfigurator.setClientInfo(CLASS, job.getConfiguration(), inputInfo);
    }

    public static void setClientPropertiesFile(Job job, String clientPropsFile) {
        InputConfigurator.setClientPropertiesFile(CLASS, job.getConfiguration(), clientPropsFile);
    }

    protected static ClientInfo getClientInfo(JobContext context) {
        return InputConfigurator.getClientInfo(CLASS, context.getConfiguration());
    }

    @Deprecated
    public static void setConnectorInfo(Job job, String principal, AuthenticationToken token) throws AccumuloSecurityException {
        if (token instanceof KerberosToken) {
            log.info((Object)"Received KerberosToken, attempting to fetch DelegationToken");
            try {
                AccumuloClient client = Accumulo.newClient().usingClientInfo(AbstractInputFormat.getClientInfo((JobContext)job)).usingToken(principal, token).build();
                token = client.securityOperations().getDelegationToken(new DelegationTokenConfig());
            }
            catch (Exception e) {
                log.warn((Object)"Failed to automatically obtain DelegationToken, Mappers/Reducers will likely fail to communicate with Accumulo", (Throwable)e);
            }
        }
        if (token instanceof DelegationTokenImpl) {
            DelegationTokenImpl delegationToken = (DelegationTokenImpl)token;
            AuthenticationTokenIdentifier identifier = delegationToken.getIdentifier();
            Token hadoopToken = new Token(identifier.getBytes(), delegationToken.getPassword(), identifier.getKind(), delegationToken.getServiceName());
            job.getCredentials().addToken(hadoopToken.getService(), hadoopToken);
        }
        InputConfigurator.setConnectorInfo(CLASS, job.getConfiguration(), principal, token);
    }

    @Deprecated
    public static void setConnectorInfo(Job job, String principal, String tokenFile) throws AccumuloSecurityException {
        AbstractInputFormat.setClientPropertiesFile(job, tokenFile);
    }

    protected static Boolean isConnectorInfoSet(JobContext context) {
        return InputConfigurator.isConnectorInfoSet(CLASS, context.getConfiguration());
    }

    protected static String getPrincipal(JobContext context) {
        return InputConfigurator.getPrincipal(CLASS, context.getConfiguration());
    }

    protected static AuthenticationToken getAuthenticationToken(JobContext context) {
        AuthenticationToken token = InputConfigurator.getAuthenticationToken(CLASS, context.getConfiguration());
        return ConfiguratorBase.unwrapAuthenticationToken(context, token);
    }

    @Deprecated
    public static void setZooKeeperInstance(Job job, ClientConfiguration clientConfig) {
        InputConfigurator.setZooKeeperInstance(CLASS, job.getConfiguration(), clientConfig);
    }

    @Deprecated
    protected static Instance getInstance(JobContext context) {
        return InputConfigurator.getInstance(CLASS, context.getConfiguration());
    }

    public static void setLogLevel(Job job, Level level) {
        InputConfigurator.setLogLevel(CLASS, job.getConfiguration(), level);
    }

    protected static Level getLogLevel(JobContext context) {
        return InputConfigurator.getLogLevel(CLASS, context.getConfiguration());
    }

    public static void setScanAuthorizations(Job job, Authorizations auths) {
        InputConfigurator.setScanAuthorizations(CLASS, job.getConfiguration(), auths);
    }

    protected static Authorizations getScanAuthorizations(JobContext context) {
        return InputConfigurator.getScanAuthorizations(CLASS, context.getConfiguration());
    }

    protected static Map<String, InputTableConfig> getInputTableConfigs(JobContext context) {
        return InputConfigurator.getInputTableConfigs(CLASS, context.getConfiguration());
    }

    protected static InputTableConfig getInputTableConfig(JobContext context, String tableName) {
        return InputConfigurator.getInputTableConfig(CLASS, context.getConfiguration(), tableName);
    }

    protected static void validateOptions(JobContext context) throws IOException {
        AccumuloClient client = InputConfigurator.getClient(CLASS, context.getConfiguration());
        InputConfigurator.validatePermissions(CLASS, context.getConfiguration(), client);
    }

    @Deprecated
    protected static ClientConfiguration getClientConfiguration(JobContext context) {
        return InputConfigurator.getClientConfiguration(CLASS, context.getConfiguration());
    }

    Map<String, Map<KeyExtent, List<Range>>> binOfflineTable(JobContext context, Table.ID tableId, List<Range> ranges) throws TableNotFoundException, AccumuloException, AccumuloSecurityException {
        ClientContext clientContext = new ClientContext(AbstractInputFormat.getClientInfo(context));
        return InputConfigurator.binOffline(tableId, ranges, clientContext);
    }

    public List<InputSplit> getSplits(JobContext context) throws IOException {
        Level logLevel = AbstractInputFormat.getLogLevel(context);
        log.setLevel(logLevel);
        AbstractInputFormat.validateOptions(context);
        SecureRandom random = new SecureRandom();
        LinkedList<InputSplit> splits = new LinkedList<InputSplit>();
        Map<String, InputTableConfig> tableConfigs = AbstractInputFormat.getInputTableConfigs(context);
        for (Map.Entry<String, InputTableConfig> tableConfigEntry : tableConfigs.entrySet()) {
            ArrayList<Range> ranges;
            boolean supportBatchScan;
            Table.ID tableId;
            String tableName = tableConfigEntry.getKey();
            InputTableConfig tableConfig = tableConfigEntry.getValue();
            ClientContext clientContext = new ClientContext(AbstractInputFormat.getClientInfo(context));
            try {
                tableId = Tables.getTableId((ClientContext)clientContext, (String)tableName);
            }
            catch (TableNotFoundException e) {
                throw new IOException(e);
            }
            boolean batchScan = InputConfigurator.isBatchScan(CLASS, context.getConfiguration());
            boolean bl = supportBatchScan = !tableConfig.isOfflineScan() && !tableConfig.shouldUseIsolatedScanners() && !tableConfig.shouldUseLocalIterators();
            if (batchScan && !supportBatchScan) {
                throw new IllegalArgumentException("BatchScanner optimization not available for offline scan, isolated, or local iterators");
            }
            boolean autoAdjust = tableConfig.shouldAutoAdjustRanges();
            if (batchScan && !autoAdjust) {
                throw new IllegalArgumentException("AutoAdjustRanges must be enabled when using BatchScanner optimization");
            }
            ArrayList<Range> arrayList = ranges = autoAdjust ? Range.mergeOverlapping(tableConfig.getRanges()) : tableConfig.getRanges();
            if (ranges.isEmpty()) {
                ranges = new ArrayList<Range>(1);
                ranges.add(new Range());
            }
            Map<Object, Object> binnedRanges = new HashMap();
            try {
                if (tableConfig.isOfflineScan()) {
                    binnedRanges = this.binOfflineTable(context, tableId, ranges);
                    while (binnedRanges == null) {
                        UtilWaitThread.sleepUninterruptibly((long)(100 + random.nextInt(100)), (TimeUnit)TimeUnit.MILLISECONDS);
                        binnedRanges = this.binOfflineTable(context, tableId, ranges);
                    }
                } else {
                    TabletLocator tl = InputConfigurator.getTabletLocator(CLASS, context.getConfiguration(), tableId);
                    tl.invalidateCache();
                    while (!tl.binRanges(clientContext, ranges, binnedRanges).isEmpty()) {
                        String tableIdStr = tableId.canonicalID();
                        if (!Tables.exists((ClientContext)clientContext, (Table.ID)tableId)) {
                            throw new TableDeletedException(tableIdStr);
                        }
                        if (Tables.getTableState((ClientContext)clientContext, (Table.ID)tableId) == TableState.OFFLINE) {
                            throw new TableOfflineException(Tables.getTableOfflineMsg((ClientContext)clientContext, (Table.ID)tableId));
                        }
                        binnedRanges.clear();
                        log.warn((Object)"Unable to locate bins for specified ranges. Retrying.");
                        UtilWaitThread.sleepUninterruptibly((long)(100 + random.nextInt(100)), (TimeUnit)TimeUnit.MILLISECONDS);
                        tl.invalidateCache();
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HashMap<Range, ArrayList<String>> splitsToAdd = null;
            if (!autoAdjust) {
                splitsToAdd = new HashMap<Range, ArrayList<String>>();
            }
            HashMap<String, String> hostNameCache = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : binnedRanges.entrySet()) {
                String ip = ((String)entry.getKey()).split(":", 2)[0];
                String location = (String)hostNameCache.get(ip);
                if (location == null) {
                    InetAddress inetAddress = InetAddress.getByName(ip);
                    location = inetAddress.getCanonicalHostName();
                    hostNameCache.put(ip, location);
                }
                for (Map.Entry extentRanges : ((Map)entry.getValue()).entrySet()) {
                    Range ke = ((KeyExtent)extentRanges.getKey()).toDataRange();
                    if (batchScan) {
                        ArrayList<Range> clippedRanges = new ArrayList<Range>();
                        for (Range r : (List)extentRanges.getValue()) {
                            clippedRanges.add(ke.clip(r));
                        }
                        BatchInputSplit split = new BatchInputSplit(tableName, tableId, clippedRanges, new String[]{location});
                        SplitUtils.updateSplit(split, tableConfig, logLevel);
                        splits.add(split);
                        continue;
                    }
                    for (Range r : (List)extentRanges.getValue()) {
                        if (autoAdjust) {
                            RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonicalID(), ke.clip(r), new String[]{location});
                            SplitUtils.updateSplit(split, tableConfig, logLevel);
                            split.setOffline(tableConfig.isOfflineScan());
                            split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                            split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                            splits.add(split);
                            continue;
                        }
                        ArrayList<String> locations = (ArrayList<String>)splitsToAdd.get(r);
                        if (locations == null) {
                            locations = new ArrayList<String>(1);
                        }
                        locations.add(location);
                        splitsToAdd.put(r, locations);
                    }
                }
            }
            if (autoAdjust) continue;
            for (Map.Entry<Object, Object> entry : splitsToAdd.entrySet()) {
                RangeInputSplit split = new RangeInputSplit(tableName, tableId.canonicalID(), (Range)entry.getKey(), ((ArrayList)entry.getValue()).toArray(new String[0]));
                SplitUtils.updateSplit(split, tableConfig, logLevel);
                split.setOffline(tableConfig.isOfflineScan());
                split.setIsolatedScan(tableConfig.shouldUseIsolatedScanners());
                split.setUsesLocalIterators(tableConfig.shouldUseLocalIterators());
                splits.add(split);
            }
        }
        return splits;
    }

    protected static abstract class AbstractRecordReader<K, V>
    extends RecordReader<K, V> {
        protected long numKeysRead;
        protected Iterator<Map.Entry<Key, Value>> scannerIterator;
        protected ScannerBase scannerBase;
        protected RangeInputSplit split;
        protected K currentK = null;
        protected V currentV = null;
        protected Key currentKey = null;

        protected AbstractRecordReader() {
        }

        protected abstract List<IteratorSetting> contextIterators(TaskAttemptContext var1, String var2);

        private void setupIterators(TaskAttemptContext context, ScannerBase scanner, String tableName, RangeInputSplit split) {
            List<IteratorSetting> iterators = null;
            if (null == split) {
                iterators = this.contextIterators(context, tableName);
            } else {
                iterators = split.getIterators();
                if (null == iterators) {
                    iterators = this.contextIterators(context, tableName);
                }
            }
            for (IteratorSetting iterator : iterators) {
                scanner.addScanIterator(iterator);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void initialize(InputSplit inSplit, TaskAttemptContext attempt) throws IOException {
            void var12_20;
            Map<String, String> map;
            AccumuloClient client;
            this.split = (RangeInputSplit)inSplit;
            log.debug((Object)("Initializing input split: " + (Object)((Object)this.split)));
            ClientInfo info = AbstractInputFormat.getClientInfo((JobContext)attempt);
            ClientContext context = new ClientContext(info);
            try {
                client = context.getClient();
            }
            catch (AccumuloException | AccumuloSecurityException e) {
                throw new IllegalStateException(e);
            }
            Authorizations authorizations = AbstractInputFormat.getScanAuthorizations((JobContext)attempt);
            String classLoaderContext = AbstractInputFormat.getClassLoaderContext((JobContext)attempt);
            String table = this.split.getTableName();
            InputTableConfig tableConfig = AbstractInputFormat.getInputTableConfig((JobContext)attempt, this.split.getTableName());
            log.debug((Object)("Creating client with user: " + info.getPrincipal()));
            log.debug((Object)("Creating scanner for table: " + table));
            log.debug((Object)("Authorizations are: " + authorizations));
            if (this.split instanceof BatchInputSplit) {
                BatchScanner scanner;
                BatchInputSplit batchSplit = (BatchInputSplit)this.split;
                try {
                    int n = 1;
                    scanner = client.createBatchScanner(this.split.getTableName(), authorizations, n);
                    this.setupIterators(attempt, (ScannerBase)scanner, this.split.getTableName(), this.split);
                    if (null != classLoaderContext) {
                        scanner.setClassLoaderContext(classLoaderContext);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new IOException(exception);
                }
                scanner.setRanges(batchSplit.getRanges());
                this.scannerBase = scanner;
            } else {
                Object scanner;
                Boolean usesLocalIterators;
                Boolean bl;
                Object isOffline = this.split.isOffline();
                if (null == isOffline) {
                    isOffline = tableConfig.isOfflineScan();
                }
                if (null == (bl = this.split.isIsolatedScan())) {
                    Boolean bl2 = tableConfig.shouldUseIsolatedScanners();
                }
                if (null == (usesLocalIterators = this.split.usesLocalIterators())) {
                    usesLocalIterators = tableConfig.shouldUseLocalIterators();
                }
                try {
                    void var12_16;
                    scanner = ((Boolean)isOffline).booleanValue() ? new OfflineScanner(context, Table.ID.of((String)this.split.getTableId()), authorizations) : new ScannerImpl(context, Table.ID.of((String)this.split.getTableId()), authorizations);
                    if (var12_16.booleanValue()) {
                        log.info((Object)"Creating isolated scanner");
                        scanner = new IsolatedScanner((Scanner)scanner);
                    }
                    if (usesLocalIterators.booleanValue()) {
                        log.info((Object)"Using local iterators");
                        scanner = new ClientSideIteratorScanner((Scanner)scanner);
                    }
                    this.setupIterators(attempt, (ScannerBase)scanner, this.split.getTableName(), this.split);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
                scanner.setRange(this.split.getRange());
                this.scannerBase = scanner;
            }
            Collection<Pair<Text, Text>> columns = this.split.getFetchedColumns();
            if (null == columns) {
                columns = tableConfig.getFetchedColumns();
            }
            for (Pair pair : columns) {
                if (pair.getSecond() != null) {
                    log.debug((Object)("Fetching column " + pair.getFirst() + ":" + pair.getSecond()));
                    this.scannerBase.fetchColumn((Text)pair.getFirst(), (Text)pair.getSecond());
                    continue;
                }
                log.debug((Object)("Fetching column family " + pair.getFirst()));
                this.scannerBase.fetchColumnFamily((Text)pair.getFirst());
            }
            SamplerConfiguration samplerConfig = this.split.getSamplerConfiguration();
            if (null == samplerConfig) {
                samplerConfig = tableConfig.getSamplerConfiguration();
            }
            if (samplerConfig != null) {
                this.scannerBase.setSamplerConfiguration(samplerConfig);
            }
            if ((map = this.split.getExecutionHints()) == null || map.isEmpty()) {
                Map<String, String> map2 = tableConfig.getExecutionHints();
            }
            if (var12_20 != null) {
                this.scannerBase.setExecutionHints((Map)var12_20);
            }
            this.scannerIterator = this.scannerBase.iterator();
            this.numKeysRead = 0L;
        }

        public void close() {
            if (null != this.scannerBase) {
                this.scannerBase.close();
            }
        }

        public float getProgress() throws IOException {
            if (this.numKeysRead > 0L && this.currentKey == null) {
                return 1.0f;
            }
            return this.split.getProgress(this.currentKey);
        }

        public K getCurrentKey() throws IOException, InterruptedException {
            return this.currentK;
        }

        public V getCurrentValue() throws IOException, InterruptedException {
            return this.currentV;
        }
    }
}

