/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.RowIterator;
import org.apache.accumulo.core.client.mapred.InputFormatBase;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.PeekingIterator;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AccumuloRowInputFormat
extends InputFormatBase<Text, PeekingIterator<Map.Entry<Key, Value>>> {
    public RecordReader<Text, PeekingIterator<Map.Entry<Key, Value>>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        log.setLevel(AccumuloRowInputFormat.getLogLevel(job));
        InputFormatBase.RecordReaderBase<Text, PeekingIterator<Map.Entry<Key, Value>>> recordReader = new InputFormatBase.RecordReaderBase<Text, PeekingIterator<Map.Entry<Key, Value>>>(){
            RowIterator rowIterator;

            @Override
            public void initialize(InputSplit inSplit, JobConf job) throws IOException {
                super.initialize(inSplit, job);
                this.rowIterator = new RowIterator(this.scannerIterator);
            }

            public boolean next(Text key, PeekingIterator<Map.Entry<Key, Value>> value) throws IOException {
                if (!this.rowIterator.hasNext()) {
                    return false;
                }
                value.initialize(this.rowIterator.next());
                this.numKeysRead = this.rowIterator.getKVCount();
                this.currentKey = (Key)((Map.Entry)value.peek()).getKey();
                key.set(this.currentKey.getRow());
                return true;
            }

            public Text createKey() {
                return new Text();
            }

            public PeekingIterator<Map.Entry<Key, Value>> createValue() {
                return new PeekingIterator();
            }
        };
        recordReader.initialize(split, job);
        return recordReader;
    }
}

