/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.mapred;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.client.mapred.AbstractInputFormat;
import org.apache.accumulo.core.client.mapred.InputFormatBase;
import org.apache.accumulo.core.client.mapreduce.InputTableConfig;
import org.apache.accumulo.core.client.mapreduce.lib.impl.InputConfigurator;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;

public class AccumuloMultiTableInputFormat
extends AbstractInputFormat<Key, Value> {
    public static void setInputTableConfigs(JobConf job, Map<String, InputTableConfig> configs) {
        InputConfigurator.setInputTableConfigs(CLASS, (Configuration)job, configs);
    }

    public RecordReader<Key, Value> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        log.setLevel(AccumuloMultiTableInputFormat.getLogLevel(job));
        InputFormatBase.RecordReaderBase<Key, Value> recordReader = new InputFormatBase.RecordReaderBase<Key, Value>(){

            public boolean next(Key key, Value value) throws IOException {
                if (this.scannerIterator.hasNext()) {
                    ++this.numKeysRead;
                    Map.Entry entry = (Map.Entry)this.scannerIterator.next();
                    this.currentKey = (Key)entry.getKey();
                    key.set(this.currentKey);
                    value.set(((Value)entry.getValue()).get());
                    if (AbstractInputFormat.log.isTraceEnabled()) {
                        AbstractInputFormat.log.trace((Object)("Processing key/value pair: " + DefaultFormatter.formatEntry((Map.Entry)entry, (boolean)true)));
                    }
                    return true;
                }
                return false;
            }

            public Key createKey() {
                return new Key();
            }

            public Value createValue() {
                return new Value();
            }
        };
        recordReader.initialize(split, job);
        return recordReader;
    }
}

