/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Element;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.context.ResponseContextWrapper;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.SecurityException;
import org.apache.abdera.security.Signature;
import org.apache.abdera.security.SignatureOptions;
import org.apache.abdera.writer.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedResponseFilter
implements Filter {
    private static final String keystoreType = "JKS";
    private String keystoreFile = null;
    private String keystorePass = null;
    private String privateKeyAlias = null;
    private String privateKeyPass = null;
    private String certificateAlias = null;
    private String algorithm = null;
    private PrivateKey signingKey = null;
    private X509Certificate cert = null;

    public SignedResponseFilter(String keystoreFile, String keystorePass, String privateKeyAlias, String privateKeyPass, String certificateAlias, String algorithm) {
        this.keystoreFile = keystoreFile;
        this.keystorePass = keystorePass;
        this.privateKeyAlias = privateKeyAlias;
        this.privateKeyPass = privateKeyPass;
        this.certificateAlias = certificateAlias;
        this.algorithm = algorithm;
        try {
            KeyStore ks = KeyStore.getInstance(keystoreType);
            InputStream in = SignedResponseFilter.class.getResourceAsStream(keystoreFile);
            ks.load(in, keystorePass.toCharArray());
            this.signingKey = (PrivateKey)ks.getKey(privateKeyAlias, privateKeyPass.toCharArray());
            this.cert = (X509Certificate)ks.getCertificate(certificateAlias);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        return new SigningResponseContextWrapper(request.getAbdera(), chain.next(request));
    }

    private Document<Element> signDocument(Abdera abdera, Document<Element> doc) throws SecurityException {
        AbderaSecurity security = new AbderaSecurity(abdera);
        if (this.signingKey == null || this.cert == null) {
            return doc;
        }
        Signature sig = security.getSignature();
        SignatureOptions options = sig.getDefaultSignatureOptions();
        options.setCertificate(this.cert);
        options.setSigningKey(this.signingKey);
        if (this.algorithm != null) {
            options.setSigningAlgorithm(this.algorithm);
        }
        Element element = doc.getRoot();
        element = sig.sign(element, options);
        return element.getDocument();
    }

    public String getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(String keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePass() {
        return this.keystorePass;
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public void setPrivateKeyAlias(String privateKeyAlias) {
        this.privateKeyAlias = privateKeyAlias;
    }

    public String getPrivateKeyPass() {
        return this.privateKeyPass;
    }

    public void setPrivateKeyPass(String privateKeyPass) {
        this.privateKeyPass = privateKeyPass;
    }

    public String getCertificateAlias() {
        return this.certificateAlias;
    }

    public void setCertificateAlias(String certificateAlias) {
        this.certificateAlias = certificateAlias;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public PrivateKey getSigningKey() {
        return this.signingKey;
    }

    public void setSigningKey(PrivateKey signingKey) {
        this.signingKey = signingKey;
    }

    public X509Certificate getCert() {
        return this.cert;
    }

    public void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    public static String getKeystoreType() {
        return keystoreType;
    }

    private class SigningResponseContextWrapper
    extends ResponseContextWrapper {
        private final Abdera abdera;

        public SigningResponseContextWrapper(Abdera abdera, ResponseContext response) {
            super(response);
            this.abdera = abdera;
        }

        public void writeTo(OutputStream out, Writer writer) throws IOException {
            try {
                this.sign(out, null);
            }
            catch (Exception se) {
                throw new RuntimeException(se);
            }
        }

        public void writeTo(OutputStream out) throws IOException {
            try {
                this.sign(out, null);
            }
            catch (Exception se) {
                throw new RuntimeException(se);
            }
        }

        private void sign(OutputStream aout, Writer writer) throws Exception {
            Document doc = null;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                if (writer == null) {
                    super.writeTo((OutputStream)out);
                } else {
                    super.writeTo((OutputStream)out, writer);
                }
                ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
                doc = this.abdera.getParser().parse((InputStream)in);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (doc != null) {
                doc = SignedResponseFilter.this.signDocument(this.abdera, (Document<Element>)doc);
                doc.writeTo(aout);
            } else {
                super.writeTo(aout);
            }
        }
    }
}

