/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import org.apache.abdera.i18n.text.Localizer;
import org.apache.abdera.model.Document;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.ProviderHelper;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.security.AbderaSecurity;
import org.apache.abdera.security.Signature;

public class SignedRequestFilter
implements Filter {
    public static final String VALID = "org.apache.abdera.security.util.servlet.SignedRequestFilter.valid";
    public static final String CERTS = "org.apache.abdera.security.util.servlet.SignedRequestFilter.certs";

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        AbderaSecurity security = new AbderaSecurity(request.getAbdera());
        Signature sig = security.getSignature();
        String method = request.getMethod();
        if (method.equals("POST") || method.equals("PUT")) {
            try {
                Document doc = request.getDocument();
                boolean valid = sig.verify(doc.getRoot(), null);
                if (!valid) {
                    return ProviderHelper.badrequest((RequestContext)request, (String)Localizer.get((String)"VALID.SIGNATURE.REQUIRED"));
                }
                request.setAttribute(VALID, (Object)valid);
                request.setAttribute(CERTS, (Object)sig.getValidSignatureCertificates(doc.getRoot(), null));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return chain.next(request);
    }
}

